/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack.helpers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.commanders.DeviceCommander;
import io.intino.cesar.box.commanders.ServerCommander;
import io.intino.cesar.box.commanders.SystemCommander;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.konos.datalake.Ness;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Query {
    static CesarGraph cesar(CesarBox box) {
        return box.graph();
    }

    private static Comparator<Device> sorter() {
        return (s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.label(), s2.label());
    }

    private static int sort(Server f1, Server f2) {
        return String.CASE_INSENSITIVE_ORDER.compare(f1.name$(), f2.name$());
    }

    public static class SystemHelper {
        public static SystemCommander commander(Ness datalake, System system) {
            return new SystemCommander(datalake, system);
        }

        public static Stream<System> sortedSystems(CesarBox box, Project project) {
            return SystemHelper.systems(box, project).stream().sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.label(), s2.label()));
        }

        public static String isRunning(System system) throws IOException {
            return system.started() ? "started" : "stopped";
        }

        public static List<System> systems(CesarBox box, Project project) {
            return Query.cesar(box).systemsOf(project.name$());
        }

        public static System searchSystemByPosition(CesarBox box, Project project, String pos) {
            List systems = SystemHelper.sortedSystems(box, project).collect(Collectors.toList());
            try {
                int position = Integer.parseInt(pos);
                return position <= systems.size() ? (System)((Object)systems.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public static System searchSystemByName(CesarBox box, Project project, String name) {
            for (System system : SystemHelper.systems(box, project)) {
                if (!system.label().equals(name) && !system.name$().equals(name)) continue;
                return system;
            }
            return null;
        }
    }

    public static class DeviceHelper {
        public static DeviceCommander commander(CesarBox box, Device device) {
            return new DeviceCommander(box.datalake(), device, box.consulTopic());
        }

        public static Stream<Device> sortedDevices(CesarBox box) {
            return Query.cesar(box).devices().stream().sorted(Query.sorter());
        }

        public static Map<Project, List<Device>> devicesByProject(CesarBox box) {
            HashMap<Project, List<Device>> devices = new HashMap<Project, List<Device>>();
            for (Project project : Query.cesar(box).projectList()) {
                devices.put(project, project.devices().stream().sorted(Query.sorter()).collect(Collectors.toList()));
            }
            return devices;
        }

        public static String label(Device device) {
            return device.status() == null || device.isCompromised() ? "*" + device.label() + "*" : device.label();
        }

        public static boolean valid(String result) {
            return !result.startsWith("Error");
        }

        public static boolean state(String alert) {
            return alert.equals("on");
        }

        public static CommandExecuted executedCommand(String message) {
            return MessageManager.fromInl(message, CommandExecuted.class).get(0);
        }

        public static Device searchDeviceByPosition(CesarBox box, String id) {
            try {
                List devices = DeviceHelper.sortedDevices(box).collect(Collectors.toList());
                int position = Integer.parseInt(id);
                return position <= devices.size() ? (Device)((Object)devices.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public static Device searchDeviceByLabel(CesarBox box, String label) {
            for (Device device : Query.cesar(box).devices()) {
                if (!device.label().equals(label)) continue;
                return device;
            }
            return null;
        }

        public static Device searchDeviceByName(CesarBox box, String name) {
            for (Device device : Query.cesar(box).devices()) {
                if (!device.name$().equals(name)) continue;
                return device;
            }
            return null;
        }

        public static Device searchDeviceByNameOrLabel(CesarBox box, String name) {
            for (Device device : box.graph().devices()) {
                if (!device.name$().equals(name) && !device.label().equals(name)) continue;
                return device;
            }
            return null;
        }
    }

    public static class ServerHelper {
        public static ServerCommander commander(Ness datalake, Server server) {
            return new ServerCommander(datalake, server);
        }

        public static Stream<Server> sortedServers(CesarBox box) {
            return Query.cesar(box).servers().stream().sorted((x$0, x$1) -> Query.sort(x$0, x$1));
        }

        public static String label(Server server) {
            return server.status() == null || server.isCompromised() ? "*" + server.label() + "*" : server.label();
        }

        public static Map<Project, List<Server>> serversByProject(CesarBox box) {
            HashMap<Project, List<Server>> servers = new HashMap<Project, List<Server>>();
            for (Project project : Query.cesar(box).projectList()) {
                servers.put(project, project.servers().stream().sorted((x$0, x$1) -> Query.sort(x$0, x$1)).collect(Collectors.toList()));
            }
            return servers;
        }

        public static Server searchServerByPosition(CesarBox box, String pos) {
            try {
                List servers = ServerHelper.sortedServers(box).collect(Collectors.toList());
                int position = Integer.parseInt(pos);
                return position <= servers.size() ? (Server)((Object)servers.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class FeederHelper {
        public static ServerCommander commander(Ness datalake, Feeder feeder) {
            return new ServerCommander(datalake, feeder);
        }

        public static Stream<Feeder> sortedFeeders(CesarBox box) {
            return Query.cesar(box).feederList().stream().sorted((x$0, x$1) -> Query.sort(x$0, x$1));
        }

        public static Map<Project, List<Feeder>> feedersByProject(CesarBox box) {
            HashMap<Project, List<Feeder>> feeders = new HashMap<Project, List<Feeder>>();
            for (Project project : Query.cesar(box).projectList()) {
                feeders.put(project, project.feeders().stream().sorted((x$0, x$1) -> Query.sort(x$0, x$1)).collect(Collectors.toList()));
            }
            return feeders;
        }

        public static String label(Feeder feeder) {
            return ServerHelper.label(feeder);
        }

        public static Feeder searchFeederByPosition(CesarBox box, String pos) {
            try {
                List feeders = FeederHelper.sortedFeeders(box).collect(Collectors.toList());
                int position = Integer.parseInt(pos);
                return position <= feeders.size() ? (Feeder)((Object)feeders.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class ProjectHelper {
        public static Stream<Project> sortedProjects(CesarBox box) {
            return Query.cesar(box).projectList().stream().sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.name$(), s2.name$()));
        }

        public static Project searchProjectByNameOrPosition(CesarBox box, String name) {
            Project project = ProjectHelper.searchProjectByPosition(box, name);
            if (project != null) {
                return project;
            }
            return ProjectHelper.searchProjectByName(box, name);
        }

        public static Project searchProjectByPosition(CesarBox box, String pos) {
            try {
                List projects = ProjectHelper.sortedProjects(box).collect(Collectors.toList());
                int position = Integer.parseInt(pos);
                return position <= projects.size() ? (Project)((Object)projects.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public static Project searchProjectByName(CesarBox box, String name) {
            return Query.cesar(box).projectList().stream().filter(p -> p.name$().equals(name)).findFirst().orElse(null);
        }
    }
}

