/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.consul.schemas.ServerStatus;
import io.intino.konos.slack.Bot;
import io.intino.ness.inl.Message;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ServerSlack
extends SlackSection {
    private CesarBox box;

    public ServerSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        ServerStatus status = Query.ServerHelper.commander(this.box.datalake(), server).status();
        if (status != null) {
            NessTanks.serverStatus().feed(Message.load((String)MessageManager.toInl(status)));
            return server.label() + "> " + SlackMessageFormatter.format(status, properties.userTimeZone());
        }
        return "Server doesn't response";
    }

    public String responsibles(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : server.responsibles()) {
            builder.append(responsible.name$());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String name(Bot.MessageProperties properties, String newName) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("rename", properties.username(), server, newName));
        return ":ok_hand:";
    }

    public String remoteConnection(Bot.MessageProperties properties, String url, Integer port, String sshUser) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        if (!url.isEmpty()) {
            server.create().remoteConnection(sshUser, url, port);
            server.core$().save();
            return ":ok_hand:";
        }
        if (server.remoteConnection() != null) {
            return server.remoteConnection().url() + ":" + server.remoteConnection().port();
        }
        return "Connection not found";
    }

    public String shutdown(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        boolean result = Query.ServerHelper.commander(this.box.datalake(), server).shutdown();
        return server.label() + "> " + (result ? ":ok_hand:" : "Error in shutdown");
    }

    public String reboot(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        boolean result = Query.ServerHelper.commander(this.box.datalake(), server).reboot();
        return server.label() + "> " + (result ? "Rebooting..." : "Couldn't be possible reboot");
    }

    public String log(Bot.MessageProperties properties) {
        return ":ok_hand:";
    }

    public String updateConsul(Bot.MessageProperties properties) {
        return "";
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        List responsibles = this.box.graph().responsibleList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("setresponsibles", properties.username(), server, users));
        return ":ok_hand:";
    }

    private Server findServer(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Server server = this.box.graph().server(context.getObjects()[0]);
        return server == null ? Query.ServerHelper.searchServerByPosition(this.box, context.getObjects()[0]) : server;
    }

    public String ssh(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "Server not found";
        }
        String[] url = server.url().split(":");
        return "`ssh " + (url.length > 1 ? "-p " + url[1] : "") + " intino@" + url[0] + "`";
    }
}

