/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.commanders.SystemCommander;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.AbstractSystem;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.consul.schemas.Operation;
import io.intino.consul.schemas.OperationResult;
import io.intino.consul.schemas.SystemLog;
import io.intino.consul.schemas.SystemStatus;
import io.intino.konos.slack.Bot;
import io.intino.ness.inl.Message;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ProjectSystemSlack
extends SlackSection {
    private CesarBox box;

    public ProjectSystemSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        SystemStatus status = Query.SystemHelper.commander(this.box.datalake(), system).status();
        if (status != null) {
            NessTanks.systemStatus().feed(Message.load((String)MessageManager.toInl(status)));
            return system.label() + "> " + SlackMessageFormatter.format(status, properties.userTimeZone());
        }
        return "System couldn't be requested";
    }

    public String name(Bot.MessageProperties properties, String newName) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("rename", properties.username(), system, newName));
        return ":ok_hand:";
    }

    public String log(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        SystemLog log = Query.SystemHelper.commander(this.box.datalake(), system).log();
        if (log != null) {
            if (!log.value().isEmpty()) {
                this.box.cesarBot().sendFile(properties.channel(), system.label() + ".txt", log.value().getBytes());
                return "";
            }
            return this.readLocalLog(system);
        }
        return "Impossible retrieve log";
    }

    private String readLocalLog(System system) {
        try {
            URL log = system.registry().log();
            if (log == null) {
                return "";
            }
            return new String(Files.readAllBytes(new File(log.getFile()).toPath()));
        }
        catch (IOException e) {
            Logger.getRootLogger().error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String subscribeLog(Bot.MessageProperties properties) {
        return "";
    }

    public String stopLog(Bot.MessageProperties properties) {
        return "";
    }

    public String responsibles(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : system.responsibles()) {
            builder.append(responsible.name$());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String parameter(Bot.MessageProperties properties, String name, String value) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("changeparameter", properties.username(), system, name, value));
        AbstractSystem.Deployment deployment = system.deploymentList().get(system.deploymentList().size() - 1);
        return ":ok_hand:";
    }

    public String start(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).start();
        if (success.booleanValue()) {
            ChangeCommitter.commit(InfrastructureOperation.message("changestatus", properties.username(), system, "start"));
        }
        return success != false ? system.label() + "> started on " + ((Server)system.consul().core$().ownerAs(Server.class)).name$() : "System couldn't be requested";
    }

    public String debug(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).debug();
        if (success.booleanValue()) {
            ChangeCommitter.commit(InfrastructureOperation.message("changestatus", properties.username(), system, "debug"));
        }
        return success != false ? system.label() + "> started on debug. Open console and start tunnel:\n" + this.connectionChain(system) : "System couldn't be requested";
    }

    public String stop(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).stop();
        if (success.booleanValue()) {
            ChangeCommitter.commit(InfrastructureOperation.message("changestatus", properties.username(), system, "stop"));
        }
        return success != false ? system.label() + "> stopped on " + ((Server)system.consul().core$().ownerAs(Server.class)).name$() : "System couldn't be requested";
    }

    public String restart(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).restart();
        if (success.booleanValue()) {
            ChangeCommitter.commit(InfrastructureOperation.message("changestatus", properties.username(), system, "start"));
        }
        return success != false ? system.label() + "> restarted on " + ((Server)system.consul().core$().ownerAs(Server.class)).name$() : "System couldn't be requested";
    }

    public String parameters(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        if (system.deploymentList().isEmpty()) {
            return "no deployments yet";
        }
        AbstractSystem.Deployment deployment = system.deploymentList().get(system.deploymentList().size() - 1);
        return String.join((CharSequence)"\n", deployment.parameterList().stream().map(p -> p.name$() + " = " + p.value()).collect(Collectors.toList()));
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        System system = this.findSystem(properties);
        if (system == null) {
            return "No system has been connected";
        }
        List responsibles = this.box.graph().responsibleList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("setResponsibles", properties.username(), system, users));
        return ":ok_hand:";
    }

    public String datalake(Bot.MessageProperties properties) {
        properties.context().command("systemDatalake");
        return "Connected to " + properties.context().getObjects()[0] + " datalake";
    }

    private String connectionChain(System system) {
        Server server = (Server)system.consul().core$().ownerAs(Server.class);
        String[] url = server.url().split(":");
        return "`ssh -N " + (url.length > 1 ? "-p " + url[1] : "") + " intino@" + url[0] + " -L " + system.debugPort() + ":127.0.0.1:" + system.debugPort() + "`";
    }

    private System findSystem(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, context.getObjects()[0]);
        System system = Query.SystemHelper.searchSystemByName(this.box, project, context.getObjects()[1]);
        return system == null ? Query.SystemHelper.searchSystemByPosition(this.box, project, context.getObjects()[1]) : system;
    }

    public String operations(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "";
        }
        SystemCommander commander = new SystemCommander(this.box.datalake(), system);
        List<Operation> result = commander.operations();
        if (result != null) {
            system.processNewOperations(result);
            system.save$();
            StringBuilder builder = new StringBuilder(system.label() + ">\n");
            for (Operation operation : result) {
                builder.append("*").append(operation.name()).append("*");
                if (!operation.description().isEmpty()) {
                    builder.append(" : ").append(operation.description());
                }
                builder.append("\n");
            }
            return builder.toString();
        }
        return "System couldn't be requested";
    }

    public String invoke(Bot.MessageProperties properties, String operation, String[] args) {
        OperationResult result;
        System system = this.findSystem(properties);
        if (system == null) {
            return "System not found";
        }
        SystemCommander commander = new SystemCommander(this.box.datalake(), system);
        List<Operation> operations = commander.operations();
        if (operations == null) {
            return "System couldn't be requested";
        }
        Operation toExecute = operations.stream().filter(op -> op.name().contains(operation)).findFirst().orElse(null);
        if (toExecute == null) {
            return "Operation not found";
        }
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
        if (properties.file() != null) {
            parameters.add(properties.file().textContent());
        }
        if ((result = commander.operation(new Operation().name(operation).parameters(parameters.subList(1, parameters.size())))) != null) {
            return system.label() + "> " + result.remarks();
        }
        return "System couldn't be requested";
    }

    public String ssh(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return "System not found";
        }
        Server server = (Server)system.consul().core$().ownerAs(Server.class);
        String[] url = server.url().split(":");
        return "`ssh" + (url.length > 1 ? "-p " + url[1] : "") + " intino@" + url[0];
    }
}

