/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.konos.slack.Bot;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectSlack
extends SlackSection {
    private final CesarBox box;

    public ProjectSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String systems(Bot.MessageProperties properties) {
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, properties.context().getObjects()[0]);
        List systems = Query.SystemHelper.sortedSystems(this.box, project).collect(Collectors.toList());
        if (systems.isEmpty()) {
            return "There aren't systems registered";
        }
        StringBuilder result = new StringBuilder("Systems:\n");
        int pos = 1;
        for (System system : systems) {
            try {
                result.append(pos++).append(") ").append(system.label()).append(" on ").append(((Server)system.consul().core$().ownerAs(Server.class)).label()).append("> ").append(Query.SystemHelper.isRunning(system)).append(system.started() ? SlackMessageFormatter.format(system, properties.userTimeZone()) : "").append("\n");
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result.toString();
    }

    public String removeSystem(Bot.MessageProperties properties, String position) {
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, properties.context().getObjects()[0]);
        System selected = Query.SystemHelper.searchSystemByPosition(this.box, project, position);
        if (selected == null) {
            return "System not found";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("remove", properties.username(), "System", selected.name$(), project.name$()));
        return ":ok_hand:";
    }

    public String system(Bot.MessageProperties properties, String systemId) {
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, properties.context().getObjects()[0]);
        if (project == null) {
            return "Project not found";
        }
        System selected = Query.SystemHelper.searchSystemByPosition(this.box, project, systemId);
        if (selected == null) {
            selected = Query.SystemHelper.searchSystemByName(this.box, project, systemId);
        }
        if (selected == null) {
            return "System not found";
        }
        properties.context().command("projectsystem");
        properties.context().objects(new String[]{project.name$(), selected.name$()});
        return "Connected to " + selected.label();
    }

    public String addDevice(Bot.MessageProperties properties, String[] ids) {
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, properties.context().getObjects()[0]);
        for (String id : ids) {
            String result = this.canAddDevice(project, id);
            if (!result.isEmpty()) {
                return result;
            }
            ChangeCommitter.commit(InfrastructureOperation.message("assignproject", properties.username(), "Device", id, project.name$()));
        }
        return ":ok_hand:";
    }

    public String addServer(Bot.MessageProperties properties, String name) {
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, properties.context().getObjects()[0]);
        String result = this.canAddServer(project, name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("assignproject", properties.username(), "Server", name, project.name$()));
        return ":ok_hand:";
    }

    public String addFeeder(Bot.MessageProperties properties, String name) {
        Project project = Query.ProjectHelper.searchProjectByNameOrPosition(this.box, properties.context().getObjects()[0]);
        String result = this.canAddFeeder(project, name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("assignproject", properties.username(), "Feeder", name, project.name$()));
        return ":ok_hand:";
    }

    private String canAddDevice(Project project, String name) {
        Device device = this.box.graph().device(name);
        if (device == null) {
            return "Device not found";
        }
        return project.devices().contains((Object)device) ? "Device is already registered for this project" : "";
    }

    private String canAddServer(Project project, String name) {
        Server server = this.box.graph().server(name);
        if (server == null) {
            return "Server not found";
        }
        return project.servers().contains((Object)server) ? "Server is already registered for this project" : "";
    }

    private String canAddFeeder(Project project, String name) {
        Feeder feeder = this.box.graph().feeder(name);
        if (feeder == null) {
            return "Feeder not found";
        }
        return project.feeders().contains((Object)feeder) ? "Feeder is already registered for this project" : "";
    }
}

