/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.konos.slack.Bot;
import java.util.Arrays;

public class ManageSlack
extends SlackSection {
    private CesarBox box;

    public ManageSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String addResponsible(Bot.MessageProperties properties, String user, String email, String[] fullName) {
        ChangeCommitter.commit(InfrastructureOperation.message("add", properties.username(), "Responsible", user, String.join((CharSequence)" ", Arrays.copyOfRange(fullName, 2, fullName.length)), null, ManageSlack.cleanURL(email)));
        return ":ok_hand:";
    }

    public String removeResponsible(Bot.MessageProperties properties, String user) {
        ChangeCommitter.commit(InfrastructureOperation.message("remove", properties.username(), "Responsible", user, new String[0]));
        return ":ok_hand:";
    }

    public String addDevices(Bot.MessageProperties properties, String[] devices) {
        StringBuilder builder = new StringBuilder();
        for (String tuple : devices) {
            String[] split = tuple.split(";");
            String result = this.addDevice(properties, split[0], split[1]);
            if (result.isEmpty()) continue;
            builder.append(split[1]).append("> ").append(result).append("\n");
        }
        String message = builder.toString();
        return message.isEmpty() ? ":ok_hand:" : message;
    }

    public String addProject(Bot.MessageProperties properties, String name) {
        String result = this.canAddProject(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("add", properties.username(), "Project", name, new String[0]));
        return ":ok_hand:";
    }

    public String removeProject(Bot.MessageProperties properties, String name) {
        String result = this.canRemoveProject(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("remove", properties.username(), "Project", name, new String[0]));
        return ":ok_hand:";
    }

    public String addDevice(Bot.MessageProperties properties, String deviceId, String name) {
        String result = this.canAddDevice(deviceId, name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("add", properties.username(), "Device", deviceId, name));
        return ":ok_hand:";
    }

    public String removeDevice(Bot.MessageProperties properties, String deviceId) {
        String result = this.canRemoveDevice(deviceId);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("remove", properties.username(), "Device", Query.DeviceHelper.searchDeviceByNameOrLabel(this.box, deviceId).core$().id(), new String[0]));
        return ":ok_hand:";
    }

    public String addFeeder(Bot.MessageProperties properties, String name, String url, String ip) {
        url = ManageSlack.cleanURL(url);
        String result = this.canAddFeeder(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("add", properties.username(), "Feeder", name, ip, url));
        return ":ok_hand:";
    }

    public String removeFeeder(Bot.MessageProperties properties, String name) {
        String result = this.canRemoveFeeder(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("remove", properties.username(), "Feeder", this.box.graph().feeder(name).core$().id(), new String[0]));
        return ":ok_hand:";
    }

    public String addServer(Bot.MessageProperties properties, String name, String url, String ip) {
        if ((url = ManageSlack.cleanURL(url)).isEmpty() || ip.isEmpty()) {
            return "Command not found";
        }
        String result = this.canAddServer(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("add", properties.username(), "Server", name, ip, url));
        return ":ok_hand:";
    }

    public String removeServer(Bot.MessageProperties properties, String name) {
        String result = this.canRemoveServer(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(InfrastructureOperation.message("remove", properties.username(), "Server", this.box.graph().server(name).core$().id(), new String[0]));
        return ":ok_hand:";
    }

    private static String cleanURL(String url) {
        return url.contains("|") ? url.split("\\|")[1].replaceAll(">|<", "") : url.replace("<", "").replace(">", "");
    }

    private String canAddProject(String name) {
        return this.box.graph().project(name) != null ? "Project already exists" : "";
    }

    private String canRemoveProject(String name) {
        return this.box.graph().project(name) == null ? "Project not found" : "";
    }

    private String canAddDevice(String deviceId, String name) {
        return Query.DeviceHelper.searchDeviceByNameOrLabel(this.box, deviceId) != null || Query.DeviceHelper.searchDeviceByNameOrLabel(this.box, name) != null ? "Device id or name already exists" : "";
    }

    private String canRemoveDevice(String deviceId) {
        return Query.DeviceHelper.searchDeviceByNameOrLabel(this.box, deviceId) == null ? "Device id not found" : "";
    }

    private String canAddFeeder(String name) {
        return this.box.graph().server(name) != null ? "Feeder already exists" : "";
    }

    private String canRemoveFeeder(String name) {
        return this.box.graph().feeder(name) == null ? "Feeder not found" : "";
    }

    private String canAddServer(String name) {
        return this.box.graph().server(name) != null ? "Server already exists" : "";
    }

    private String canRemoveServer(String name) {
        return this.box.graph().server(name) == null ? "Server not found" : "";
    }
}

