/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.Responsible;
import io.intino.consul.schemas.ServerStatus;
import io.intino.konos.slack.Bot;
import io.intino.ness.inl.Message;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FeederSlack
extends SlackSection {
    private CesarBox box;

    public FeederSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        ServerStatus status = Query.FeederHelper.commander(this.box.datalake(), feeder).status();
        if (status != null) {
            NessTanks.feederStatus().feed(Message.load((String)MessageManager.toInl(status)));
            return feeder.label() + "> " + SlackMessageFormatter.format(status, properties.userTimeZone());
        }
        return "Feeder doesn't response";
    }

    public String responsibles(Bot.MessageProperties properties) {
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : feeder.responsibles()) {
            builder.append(responsible.name$());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String name(Bot.MessageProperties properties, String newName) {
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("rename", properties.username(), feeder, newName));
        return ":ok_hand:";
    }

    public String remoteConnection(Bot.MessageProperties properties, String url, Integer port, String sshUser) {
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        if (!url.isEmpty()) {
            feeder.create().remoteConnection(sshUser, url, port);
            feeder.core$().save();
            return ":ok_hand:";
        }
        if (feeder.remoteConnection() != null) {
            return feeder.remoteConnection().url() + ":" + feeder.remoteConnection().port();
        }
        return "Connection not found";
    }

    public String shutdown(Bot.MessageProperties properties) {
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        boolean result = Query.FeederHelper.commander(this.box.datalake(), feeder).shutdown();
        return feeder.label() + "> " + (result ? ":ok_hand:" : "Error in shutdown");
    }

    public String reboot(Bot.MessageProperties properties) {
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        boolean result = Query.FeederHelper.commander(this.box.datalake(), feeder).reboot();
        return feeder.label() + "> " + (result ? "Rebooting..." : "Couldn't be possible reboot");
    }

    public String log(Bot.MessageProperties properties) {
        return ":ok_hand:";
    }

    public String updateConsul(Bot.MessageProperties properties) {
        return "";
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Feeder feeder = this.findFeeder(properties);
        if (feeder == null) {
            return "No feeder has been connected";
        }
        List responsibles = this.box.graph().responsibleList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("setresponsibles", properties.username(), feeder, users));
        return ":ok_hand:";
    }

    private Feeder findFeeder(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Feeder feeder = this.box.graph().feeder(context.getObjects()[0]);
        return feeder == null ? Query.FeederHelper.searchFeederByPosition(this.box, context.getObjects()[0]) : feeder;
    }
}

