/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.ImageHelper;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.checkers.ScreenDownloader;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.slack.Bot;
import io.intino.ness.inl.Message;
import io.intino.sumus.box.SumusBox;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceSlack
extends SlackSection {
    private CesarBox box;

    public DeviceSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String response = Query.DeviceHelper.commander(this.box, device).status();
        if (Query.DeviceHelper.valid(response)) {
            Status status = MessageManager.fromInl(response, Status.class).get(0);
            NessTanks.deviceStatus().feed(Message.load((String)MessageManager.toInl(status)));
            return device.label() + "> " + SlackMessageFormatter.format(status, properties.userTimeZone());
        }
        return device.label() + "> " + response;
    }

    public String reboot(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).reboot();
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String responsibles(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : device.responsibles()) {
            builder.append(responsible.name$());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        List responsibles = this.box.graph().responsibleList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("setresponsibles", properties.username(), device, users));
        return ":ok_hand:";
    }

    public String setNotifications(Bot.MessageProperties properties, String unplug, String temperature, String battery, String lowBattery, String disconnected) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("setnotifications", properties.username(), device, "" + Query.DeviceHelper.state(unplug), "" + Query.DeviceHelper.state(temperature), "" + Query.DeviceHelper.state(battery), "" + Query.DeviceHelper.state(lowBattery), "" + Query.DeviceHelper.state(disconnected)));
        return "Notifications are now: \n\tunplug:" + unplug + "\n\ttemperature:" + temperature + "\n\tbattery:" + battery + "\n\tlowBattery:" + lowBattery + "\n\tdisconnected:" + disconnected + "\n";
    }

    public String screen(Bot.MessageProperties properties, String state) {
        Device device = this.findDevice(properties);
        if (state.isEmpty()) {
            return this.captureScreen(properties);
        }
        if (device == null) {
            return "No device has been connected";
        }
        String screenon = Query.DeviceHelper.state(state) ? Query.DeviceHelper.commander(this.box, device).screenOn() : Query.DeviceHelper.commander(this.box, device).screenOff();
        return device.label() + "> " + (Query.DeviceHelper.valid(screenon) ? ":ok_hand:" : screenon);
    }

    public String grid(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        byte[] capturedScreen = new ScreenDownloader(this.box).screenOf(device);
        if (capturedScreen != null) {
            this.box.cesarBot().sendFile(properties.channel(), device.label() + "> Capture.jpg", ImageHelper.decodeWithGrid(capturedScreen, device));
        }
        return capturedScreen != null ? "" : device.label() + "> Error capturing screen";
    }

    private String captureScreen(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        byte[] capturedScreen = new ScreenDownloader(this.box).screenOf(device);
        if (capturedScreen != null) {
            BufferedImage image = ImageHelper.withTimeMark(device.screen(), capturedScreen);
            if (image != null) {
                device.screen().save(ImageHelper.decodeImage(image));
            }
            this.box.cesarBot().sendFile(properties.channel(), device.label() + "> Capture.jpg", capturedScreen);
            device.update(d -> ((SumusBox)this.box.owner()).refreshDisplaysOf((Catalog)Displays.displayFor(this.box, "assetCatalog").element(), false, new Item[]{new Item().id(d.core$().id()).name(d.name$()).object((Object)d)}));
        }
        return capturedScreen != null ? "" : device.label() + "> Error capturing screen";
    }

    public String tap(Bot.MessageProperties properties, String square) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        return this.tapPixel(properties, ImageHelper.pixelXOf(square, device), ImageHelper.pixelYOf(square, device));
    }

    public String tapPixel(Bot.MessageProperties properties, int x, int y) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).tap(x, y);
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String drag(Bot.MessageProperties properties, String from, String to) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).drag(ImageHelper.pixelXOf(from, device), ImageHelper.pixelYOf(from, device), ImageHelper.pixelXOf(from, device), ImageHelper.pixelYOf(to, device));
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String kill(Bot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).killTask(packageName);
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String launch(Bot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).launchTask(packageName);
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String uninstall(Bot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).deleteAPP(packageName);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String install(Bot.MessageProperties properties, String url) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).installAPP(url.replaceAll("<|>", ""));
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String name(Bot.MessageProperties properties, String newName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("rename", properties.username(), device, newName));
        properties.context().objects(new String[]{newName});
        return ":ok_hand:";
    }

    public String update(Bot.MessageProperties properties, String url) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).updateAPP(url.replaceAll("<|>", ""));
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    public String execute(Bot.MessageProperties properties, String[] args) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return "No device has been connected";
        }
        String result = Query.DeviceHelper.commander(this.box, device).execute(args);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? ":ok_hand:" : result);
    }

    private Device findDevice(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Device device = Query.DeviceHelper.searchDeviceByName(this.box, context.getObjects()[0]);
        return device == null ? Query.DeviceHelper.searchDeviceByPosition(this.box, context.getObjects()[0]) : device;
    }
}

