/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.SlackSection;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.box.slack.helpers.UserManager;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.konos.slack.Bot;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CesarBotSlack
extends SlackSection {
    private static final String FIRST_LINE = ">\n";
    private CesarBox box;

    public CesarBotSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
        UserManager.addUsersFromSlack(this.box, session.getUsers());
    }

    public String devices(Bot.MessageProperties properties) {
        Map<Project, List<Device>> devices = Query.DeviceHelper.devicesByProject(this.box);
        StringBuilder builder = new StringBuilder(FIRST_LINE);
        int pos = 1;
        for (Project project : devices.keySet()) {
            if (!devices.get((Object)project).isEmpty()) {
                builder.append("*Project ").append(project.name$()).append("*\n----------------\n");
            }
            for (Device d2 : devices.get((Object)project)) {
                builder.append(pos++).append(") ").append(Query.DeviceHelper.label(d2)).append("\t").append(SlackMessageFormatter.format(d2, properties.userTimeZone())).append("\n");
            }
        }
        List noProjectDevices = Query.DeviceHelper.sortedDevices(this.box).filter(d -> d.owner() == null).collect(Collectors.toList());
        if (noProjectDevices.isEmpty()) {
            return builder.toString().equals(FIRST_LINE) ? "There aren't devices registered yet" : builder.toString();
        }
        builder.append("*Unassigned").append("*\n----------------\n");
        for (Device d3 : noProjectDevices) {
            builder.append(pos++).append(") ").append(Query.DeviceHelper.label(d3)).append("\t").append(SlackMessageFormatter.format(d3, properties.userTimeZone())).append("\n");
        }
        return builder.toString();
    }

    public String devicesId(Bot.MessageProperties properties) {
        StringBuilder result = new StringBuilder();
        Query.DeviceHelper.sortedDevices(this.box).forEach(d -> result.append(Query.DeviceHelper.label(d)).append("\t").append(d.name$()).append("\n"));
        return result.toString().isEmpty() ? "There aren't devices registered yet" : result.toString();
    }

    public String assets(Bot.MessageProperties properties) {
        return this.devices(properties) + "\n" + this.servers(properties) + "\n" + this.feeders(properties);
    }

    public String servers(Bot.MessageProperties properties) {
        Map<Project, List<Server>> servers = Query.ServerHelper.serversByProject(this.box);
        StringBuilder builder = new StringBuilder(FIRST_LINE);
        int pos = 1;
        for (Project project : servers.keySet()) {
            if (!servers.get((Object)project).isEmpty()) {
                builder.append("*Project ").append(project.name$()).append("*\n----------------\n");
            }
            for (Server server : servers.get((Object)project)) {
                builder.append(pos++).append(") ").append(server.name$()).append(SlackMessageFormatter.format(server, properties.userTimeZone())).append("\n");
            }
        }
        List noProjectServers = Query.ServerHelper.sortedServers(this.box).filter(d -> d.owner() == null).collect(Collectors.toList());
        if (noProjectServers.isEmpty()) {
            return builder.toString().equals(FIRST_LINE) ? "There aren't servers registered yet" : builder.toString();
        }
        this.appendUnassigned(properties, builder, pos, noProjectServers);
        return builder.toString();
    }

    public String feeder(Bot.MessageProperties properties, String name) {
        Server selected = Query.FeederHelper.searchFeederByPosition(this.box, name);
        if (selected == null) {
            selected = this.box.graph().server(name);
        }
        if (selected == null) {
            return "Feeder not found";
        }
        properties.context().command("feeder");
        properties.context().objects(new String[]{name});
        return "Connected to " + selected.name$();
    }

    private void appendUnassigned(Bot.MessageProperties properties, StringBuilder builder, int pos, List<? extends Server> noProjectServers) {
        builder.append("*Unassigned").append("*\n----------------\n");
        for (Server server : noProjectServers) {
            builder.append(pos++).append(") ").append(server.name$()).append(SlackMessageFormatter.format(server, properties.userTimeZone())).append("\n");
        }
    }

    public String feeders(Bot.MessageProperties properties) {
        Map<Project, List<Feeder>> feeders = Query.FeederHelper.feedersByProject(this.box);
        StringBuilder builder = new StringBuilder(FIRST_LINE);
        int pos = 1;
        for (Project project : feeders.keySet()) {
            if (!feeders.get((Object)project).isEmpty()) {
                builder.append("*Project ").append(project.name$()).append("*\n----------------\n");
            }
            for (Feeder feeder : feeders.get((Object)project)) {
                builder.append(pos++).append(") ").append(feeder.name$()).append(SlackMessageFormatter.format(feeder, properties.userTimeZone())).append("\n");
            }
        }
        List noProjectFeeders = Query.FeederHelper.sortedFeeders(this.box).filter(d -> d.owner() == null).collect(Collectors.toList());
        if (noProjectFeeders.isEmpty()) {
            return builder.toString().equals(FIRST_LINE) ? "There aren't feeders registered yet" : builder.toString();
        }
        this.appendUnassigned(properties, builder, pos, noProjectFeeders);
        return builder.toString();
    }

    public String projects(Bot.MessageProperties properties) {
        List projects = Query.ProjectHelper.sortedProjects(this.box).collect(Collectors.toList());
        if (projects.isEmpty()) {
            return "There aren't projects registered";
        }
        StringBuilder builder = new StringBuilder("Projects:\n");
        int pos = 1;
        for (Project project : projects) {
            builder.append(pos++).append(") ").append(project.name$()).append("\n");
        }
        return builder.toString();
    }

    public String responsibles(Bot.MessageProperties properties) {
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : this.box.graph().responsibleList()) {
            builder.append(responsible.label());
            builder.append(" (").append(responsible.name$()).append("): ");
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String message = builder.toString();
        return message.trim().isEmpty() ? "There aren't responsibles registered" : message;
    }

    public String developToken(Bot.MessageProperties properties) {
        return properties.username();
    }

    public String notifications(Bot.MessageProperties properties, String state) {
        if (state.isEmpty()) {
            return "Notifications are " + (this.box.graph().configuration().notifications() ? "on" : "off");
        }
        if (!state.equals("on") && !state.equals("off")) {
            return "State does not match (on /off)";
        }
        ChangeCommitter.commit(InfrastructureOperation.message("Notifications", properties.username(), "Configuration", null, state.equals("on") + ""));
        return ":ok_hand:";
    }

    public String issues(Bot.MessageProperties properties) {
        int current;
        StringBuilder result = new StringBuilder();
        List devices = Query.DeviceHelper.sortedDevices(this.box).collect(Collectors.toList());
        List servers = Query.ServerHelper.sortedServers(this.box).collect(Collectors.toList());
        int pos = 1;
        for (Device d : devices) {
            current = pos++;
            if (d.status() != null && !d.isCompromised()) continue;
            result.append(current).append(") ").append(Query.DeviceHelper.label(d)).append("\t").append(SlackMessageFormatter.formatCompromised(d, properties.userTimeZone())).append("\n");
        }
        for (Server s : servers) {
            current = pos++;
            if (s.status() != null && !s.isCompromised()) continue;
            result.append(current).append(") ").append(Query.ServerHelper.label(s)).append("\t").append(SlackMessageFormatter.formatCompromised(s, properties.userTimeZone())).append("\n");
        }
        return result.toString().isEmpty() ? "There aren't issues" : result.toString();
    }

    public String manage(Bot.MessageProperties properties) {
        properties.context().command("manage");
        return "Now you are in management area";
    }

    public String device(Bot.MessageProperties properties, String deviceId) {
        Device selected = Query.DeviceHelper.searchDeviceByPosition(this.box, deviceId);
        if (selected == null) {
            selected = Query.DeviceHelper.searchDeviceByLabel(this.box, deviceId);
        }
        if (selected == null) {
            return "No device has been connected";
        }
        properties.context().command("device");
        properties.context().objects(new String[]{selected.name$()});
        return "Connected to " + selected.label();
    }

    public String server(Bot.MessageProperties properties, String name) {
        Server selected = Query.ServerHelper.searchServerByPosition(this.box, name);
        if (selected == null) {
            selected = this.box.graph().server(name);
        }
        if (selected == null) {
            return "Server not found";
        }
        properties.context().command("server");
        properties.context().objects(new String[]{selected.name$()});
        return "Connected to " + selected.name$();
    }

    public String project(Bot.MessageProperties properties, String name) {
        Project selected = Query.ProjectHelper.searchProjectByPosition(this.box, name);
        if (selected == null) {
            selected = this.box.graph().project(name);
        }
        if (selected == null) {
            return "Project not found";
        }
        properties.context().command("project");
        properties.context().objects(new String[]{selected.name$()});
        return "Connected to " + selected.name$();
    }
}

