/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.schemas;

import io.intino.cesar.box.schemas.Artifactory;
import io.intino.cesar.box.schemas.Boot;
import io.intino.cesar.box.schemas.Command;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.box.schemas.Crash;
import io.intino.cesar.box.schemas.DeviceIssues;
import io.intino.cesar.box.schemas.DeviceLoadMetrics;
import io.intino.cesar.box.schemas.DeviceStatus;
import io.intino.cesar.box.schemas.DeviceTimelineEvent;
import io.intino.cesar.box.schemas.InfrastructureOperation;
import io.intino.cesar.box.schemas.Issue;
import io.intino.cesar.box.schemas.Packaging;
import io.intino.cesar.box.schemas.Parameter;
import io.intino.cesar.box.schemas.ProjectSchema;
import io.intino.cesar.box.schemas.RemoteConnection;
import io.intino.cesar.box.schemas.Runtime;
import io.intino.cesar.box.schemas.ServerSchema;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.box.schemas.SystemLoadMetrics;
import io.intino.cesar.box.schemas.SystemLog;
import io.intino.cesar.box.schemas.SystemSchema;
import io.intino.cesar.box.schemas.TimeRange;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ActivitySchemaAdapters {
    public static Command commandFromLayer(Layer layer) {
        return ActivitySchemaAdapters.commandFromNode(layer.core$());
    }

    private static Command commandFromNode(Node node) {
        Command schema = new Command();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (!variable.equals("operation")) continue;
            schema.operation(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static CommandExecuted commandExecutedFromLayer(Layer layer) {
        return ActivitySchemaAdapters.commandExecutedFromNode(layer.core$());
    }

    private static CommandExecuted commandExecutedFromNode(Node node) {
        CommandExecuted schema = new CommandExecuted();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("ts")) {
                schema.ts((Instant)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("commandName")) {
                schema.commandName(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("remarks")) {
                schema.remarks(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("deviceId")) {
                schema.deviceId(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("consulVersion")) continue;
            schema.consulVersion(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static Status statusFromLayer(Layer layer) {
        return ActivitySchemaAdapters.statusFromNode(layer.core$());
    }

    private static Status statusFromNode(Node node) {
        Status schema = new Status();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("deviceId")) {
                schema.deviceId(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("ts")) {
                schema.ts((Instant)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("consulVersion")) {
                schema.consulVersion(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("temperature")) {
                schema.temperature((Double)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("battery")) {
                schema.battery((Double)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("cpuUsage")) {
                schema.cpuUsage((Double)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("isPlugged")) {
                schema.isPlugged((Boolean)((List)variables.get(variable)).get(0));
            }
            if (!variable.equals("isScreenOn")) continue;
            schema.isScreenOn((Boolean)((List)variables.get(variable)).get(0));
        }
        return schema;
    }

    public static DeviceStatus deviceStatusFromLayer(Layer layer) {
        return ActivitySchemaAdapters.deviceStatusFromNode(layer.core$());
    }

    private static DeviceStatus deviceStatusFromNode(Node node) {
        DeviceStatus schema = new DeviceStatus();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (!variable.equals("screen")) continue;
            schema.screen(((List)variables.get(variable)).get(0).toString());
        }
        for (Node component : node.componentList()) {
            if (!component.name().equalsIgnoreCase(Status.class.getSimpleName())) continue;
            schema.status(ActivitySchemaAdapters.statusFromNode(component));
        }
        return schema;
    }

    public static SystemSchema systemSchemaFromLayer(Layer layer) {
        return ActivitySchemaAdapters.systemSchemaFromNode(layer.core$());
    }

    private static SystemSchema systemSchemaFromNode(Node node) {
        SystemSchema schema = new SystemSchema();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("project")) {
                schema.project(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("name")) {
                schema.name(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("tag")) {
                schema.tag().addAll((List)variables.get(variable));
            }
            if (variable.equals("jmxPort")) {
                schema.jmxPort((Integer)((List)variables.get(variable)).get(0));
            }
            if (!variable.equals("publicURL")) continue;
            schema.publicURL(((List)variables.get(variable)).get(0).toString());
        }
        for (Node component : node.componentList()) {
            if (component.name().equalsIgnoreCase(Packaging.class.getSimpleName())) {
                schema.packaging(ActivitySchemaAdapters.packagingFromNode(component));
            }
            if (component.name().equalsIgnoreCase(Artifactory.class.getSimpleName())) {
                schema.artifactoryList().add(ActivitySchemaAdapters.artifactoryFromNode(component));
            }
            if (!component.name().equalsIgnoreCase(Runtime.class.getSimpleName())) continue;
            schema.runtime(ActivitySchemaAdapters.runtimeFromNode(component));
        }
        return schema;
    }

    public static Packaging packagingFromLayer(Layer layer) {
        return ActivitySchemaAdapters.packagingFromNode(layer.core$());
    }

    private static Packaging packagingFromNode(Node node) {
        Packaging schema = new Packaging();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("artifact")) {
                schema.artifact(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("classpathPrefix")) continue;
            schema.classpathPrefix(((List)variables.get(variable)).get(0).toString());
        }
        for (Node component : node.componentList()) {
            if (!component.name().equalsIgnoreCase(Parameter.class.getSimpleName())) continue;
            schema.parameterList().add(ActivitySchemaAdapters.parameterFromNode(component));
        }
        return schema;
    }

    public static Parameter parameterFromLayer(Layer layer) {
        return ActivitySchemaAdapters.parameterFromNode(layer.core$());
    }

    private static Parameter parameterFromNode(Node node) {
        Parameter schema = new Parameter();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("name")) {
                schema.name(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("value")) continue;
            schema.value(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static Artifactory artifactoryFromLayer(Layer layer) {
        return ActivitySchemaAdapters.artifactoryFromNode(layer.core$());
    }

    private static Artifactory artifactoryFromNode(Node node) {
        Artifactory schema = new Artifactory();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("id")) {
                schema.id(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("url")) {
                schema.url(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("user")) {
                schema.user(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("password")) continue;
            schema.password(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static Runtime runtimeFromLayer(Layer layer) {
        return ActivitySchemaAdapters.runtimeFromNode(layer.core$());
    }

    private static Runtime runtimeFromNode(Node node) {
        Runtime schema = new Runtime();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("serverName")) {
                schema.serverName(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("managementPort")) {
                schema.managementPort((Integer)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("ip")) {
                schema.ip(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("port")) continue;
            schema.port((Integer)((List)variables.get(variable)).get(0));
        }
        return schema;
    }

    public static ProjectSchema projectSchemaFromLayer(Layer layer) {
        return ActivitySchemaAdapters.projectSchemaFromNode(layer.core$());
    }

    private static ProjectSchema projectSchemaFromNode(Node node) {
        ProjectSchema schema = new ProjectSchema();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (!variable.equals("name")) continue;
            schema.name(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static ServerSchema serverSchemaFromLayer(Layer layer) {
        return ActivitySchemaAdapters.serverSchemaFromNode(layer.core$());
    }

    private static ServerSchema serverSchemaFromNode(Node node) {
        ServerSchema schema = new ServerSchema();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("name")) {
                schema.name(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("ip")) {
                schema.ip(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("performance")) continue;
            schema.performance(((List)variables.get(variable)).get(0).toString());
        }
        for (Node component : node.componentList()) {
            if (!component.name().equalsIgnoreCase(RemoteConnection.class.getSimpleName())) continue;
            schema.remoteConnection(ActivitySchemaAdapters.remoteConnectionFromNode(component));
        }
        return schema;
    }

    public static RemoteConnection remoteConnectionFromLayer(Layer layer) {
        return ActivitySchemaAdapters.remoteConnectionFromNode(layer.core$());
    }

    private static RemoteConnection remoteConnectionFromNode(Node node) {
        RemoteConnection schema = new RemoteConnection();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("url")) {
                schema.url(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("port")) {
                schema.port((Integer)((List)variables.get(variable)).get(0));
            }
            if (!variable.equals("user")) continue;
            schema.user(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static Boot bootFromLayer(Layer layer) {
        return ActivitySchemaAdapters.bootFromNode(layer.core$());
    }

    private static Boot bootFromNode(Node node) {
        Boot schema = new Boot();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("ts")) {
                schema.ts((Instant)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("deviceId")) {
                schema.deviceId(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("consulVersion")) continue;
            schema.consulVersion(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static Crash crashFromLayer(Layer layer) {
        return ActivitySchemaAdapters.crashFromNode(layer.core$());
    }

    private static Crash crashFromNode(Node node) {
        Crash schema = new Crash();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("ts")) {
                schema.ts((Instant)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("app")) {
                schema.app(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("appVersion")) {
                schema.appVersion(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("deviceId")) {
                schema.deviceId(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("stack")) {
                schema.stack(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("consulVersion")) continue;
            schema.consulVersion(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }

    public static InfrastructureOperation infrastructureOperationFromLayer(Layer layer) {
        return ActivitySchemaAdapters.infrastructureOperationFromNode(layer.core$());
    }

    private static InfrastructureOperation infrastructureOperationFromNode(Node node) {
        InfrastructureOperation schema = new InfrastructureOperation();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("operation")) {
                schema.operation(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("user")) {
                schema.user(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("objectType")) {
                schema.objectType(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("objectID")) {
                schema.objectID(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("parameters")) continue;
            schema.parameters().addAll((List)variables.get(variable));
        }
        return schema;
    }

    public static SystemLog systemLogFromLayer(Layer layer) {
        return ActivitySchemaAdapters.systemLogFromNode(layer.core$());
    }

    private static SystemLog systemLogFromNode(Node node) {
        SystemLog schema = new SystemLog();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("items")) {
                schema.items().addAll((List)variables.get(variable));
            }
            if (!variable.equals("hasNextPage")) continue;
            schema.hasNextPage((Boolean)((List)variables.get(variable)).get(0));
        }
        return schema;
    }

    public static DeviceIssues deviceIssuesFromLayer(Layer layer) {
        return ActivitySchemaAdapters.deviceIssuesFromNode(layer.core$());
    }

    private static DeviceIssues deviceIssuesFromNode(Node node) {
        DeviceIssues schema = new DeviceIssues();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (Node component : node.componentList()) {
            if (!component.name().equalsIgnoreCase(Issue.class.getSimpleName())) continue;
            schema.issueList().add(ActivitySchemaAdapters.issueFromNode(component));
        }
        return schema;
    }

    public static Issue issueFromLayer(Layer layer) {
        return ActivitySchemaAdapters.issueFromNode(layer.core$());
    }

    private static Issue issueFromNode(Node node) {
        Issue schema = new Issue();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("ts")) {
                schema.ts((Instant)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("issueType")) {
                schema.issueType(((List)variables.get(variable)).get(0).toString());
            }
            if (!variable.equals("parameters")) continue;
            schema.parameters().addAll((List)variables.get(variable));
        }
        return schema;
    }

    public static DeviceLoadMetrics deviceLoadMetricsFromLayer(Layer layer) {
        return ActivitySchemaAdapters.deviceLoadMetricsFromNode(layer.core$());
    }

    private static DeviceLoadMetrics deviceLoadMetricsFromNode(Node node) {
        DeviceLoadMetrics schema = new DeviceLoadMetrics();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        return schema;
    }

    public static SystemLoadMetrics systemLoadMetricsFromLayer(Layer layer) {
        return ActivitySchemaAdapters.systemLoadMetricsFromNode(layer.core$());
    }

    private static SystemLoadMetrics systemLoadMetricsFromNode(Node node) {
        SystemLoadMetrics schema = new SystemLoadMetrics();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("updateMinutesInterval")) {
                schema.updateMinutesInterval((Integer)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("maxCpu")) {
                schema.maxCpu((Integer)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("maxMemory")) {
                schema.maxMemory((Integer)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("maxThreads")) {
                schema.maxThreads((Integer)((List)variables.get(variable)).get(0));
            }
            if (!variable.equals("from")) continue;
            schema.from((Instant)((List)variables.get(variable)).get(0));
        }
        return schema;
    }

    public static DeviceTimelineEvent deviceTimelineEventFromLayer(Layer layer) {
        return ActivitySchemaAdapters.deviceTimelineEventFromNode(layer.core$());
    }

    private static DeviceTimelineEvent deviceTimelineEventFromNode(Node node) {
        DeviceTimelineEvent schema = new DeviceTimelineEvent();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("id")) {
                schema.id(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("content")) {
                schema.content(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("icon")) {
                schema.icon(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("type")) {
                schema.type(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("className")) {
                schema.className(((List)variables.get(variable)).get(0).toString());
            }
            if (variable.equals("start")) {
                schema.start((Instant)((List)variables.get(variable)).get(0));
            }
            if (!variable.equals("end")) continue;
            schema.end((Instant)((List)variables.get(variable)).get(0));
        }
        return schema;
    }

    public static TimeRange timeRangeFromLayer(Layer layer) {
        return ActivitySchemaAdapters.timeRangeFromNode(layer.core$());
    }

    private static TimeRange timeRangeFromNode(Node node) {
        TimeRange schema = new TimeRange();
        Map variables = node.variables();
        variables.put("name", Collections.singletonList(node.name()));
        variables.put("id", Collections.singletonList(node.id()));
        for (String variable : variables.keySet()) {
            if (variable.equals("from")) {
                schema.from((Instant)((List)variables.get(variable)).get(0));
            }
            if (variable.equals("to")) {
                schema.to((Instant)((List)variables.get(variable)).get(0));
            }
            if (!variable.equals("scale")) continue;
            schema.scale(((List)variables.get(variable)).get(0).toString());
        }
        return schema;
    }
}

