/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers.projects;

import io.intino.cesar.Utils;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.commanders.ServerCommander;
import io.intino.cesar.box.commanders.SystemCommander;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.schemas.Artifactory;
import io.intino.cesar.box.schemas.Parameter;
import io.intino.cesar.box.schemas.SystemSchema;
import io.intino.cesar.graph.AbstractSystem;
import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.SystemStatus;
import io.intino.consul.ConsulJMSAccessor;
import io.intino.consul.schemas.Operation;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.SumusStore;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Session;

public class System {
    private static io.intino.cesar.graph.System load(CesarGraph cesar, String id) {
        Node node = cesar.core$().load(id);
        return node == null ? null : (io.intino.cesar.graph.System)node.as(io.intino.cesar.graph.System.class);
    }

    public static class ChangeParameter
    extends InfrastructureHandler {
        private final String name = this.parameters()[0];
        private final String value = this.parameters()[1];

        public ChangeParameter(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = System.load(this.cesar, this.objectID());
            if (system == null) {
                return;
            }
            List<AbstractSystem.Deployment> deployments = system.deploymentList();
            if (deployments.isEmpty()) {
                return;
            }
            AbstractSystem.Deployment deployment = deployments.get(deployments.size() - 1);
            AbstractSystem.Deployment.Parameter parameter = deployment.parameterList().stream().filter(p -> p.name().equals(this.name)).findFirst().orElse(null);
            if (parameter == null) {
                return;
            }
            parameter.value(this.value);
            this.notifyConsul(system, parameter);
        }

        private void notifyConsul(io.intino.cesar.graph.System system, AbstractSystem.Deployment.Parameter parameter) {
            new Thread(() -> {
                ServerCommander accessor = new ServerCommander(this.box.datalake(), (Server)system.consul().core$().ownerAs(Server.class));
                accessor.parameter(system.name$(), ((Project)system.core$().ownerAs(Project.class)).name$(), parameter.name(), parameter.value());
            }).start();
        }
    }

    public static class ChangeStatus
    extends InfrastructureHandler {
        public ChangeStatus(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = System.load(this.cesar, this.objectID());
            if (system == null) {
                return;
            }
            if (this.infrastructureOperation.parameters()[0].equals("start")) {
                system.started(true);
                system.debugging(false);
            }
            if (this.infrastructureOperation.parameters()[0].equals("stop")) {
                system.started(false);
                system.debugging(false);
            }
            if (this.infrastructureOperation.parameters()[0].equals("debug")) {
                system.started(true);
                system.debugging(true);
            }
            system.save$();
        }
    }

    public static class NewDeployment
    extends InfrastructureHandler {
        private final SystemSchema schema = (SystemSchema)MessageManager.gson().fromJson(this.parameters()[0], SystemSchema.class);

        public NewDeployment(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = this.cesar.systemFrom(this.schema.project(), this.objectID(), this.schema.runtime().serverName());
            if (system == null) {
                return;
            }
            system.artifact().classpathPrefix(this.schema.packaging().classpathPrefix());
            AbstractSystem.Deployment deployment = system.create().deployment();
            deployment.create().prerequisites();
            deployment.success(true);
            if (this.schema.packaging() != null) {
                for (Parameter newParameter : this.schema.packaging().parameterList()) {
                    deployment.create(newParameter.name()).parameter(newParameter.name(), newParameter.value());
                }
            }
            system.currentIssues().clear();
            system.started(true);
            system.save$();
            new Thread(() -> this.collectOperations(system)).start();
        }

        private void collectOperations(io.intino.cesar.graph.System system) {
            if (system.operations() == null) {
                system.create().operations();
            }
            system.operations().clear().operation(o -> true);
            List<Operation> answer = this.operationsOf(system);
            if (answer != null) {
                system.processNewOperations(answer);
            }
            system.save$();
        }

        private List<Operation> operationsOf(io.intino.cesar.graph.System system) {
            return new SystemCommander(this.box.datalake(), system).operations();
        }
    }

    public static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = this.cesar.systemFrom(this.parameters()[0], this.objectID());
            system.label(this.parameters()[0]);
            system.save$();
        }
    }

    public static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = this.cesar.systemFrom(this.parameters()[0], this.objectID());
            if (system.consul() != null) {
                Server server = (Server)system.consul().core$().ownerAs(Server.class);
                try {
                    Session session = this.box.datalake().connection().createSession(false, 1);
                    ConsulJMSAccessor accessor = new ConsulJMSAccessor(session, server.name$());
                    accessor.retract(((Project)system.core$().ownerAs(Project.class)).label(), system.label(), success -> {});
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                system.consul().systems().remove((Object)system);
                server.releasePort(system.debugPort());
                server.releasePort(system.operations().port());
            }
            if (system.registry().log() != null) {
                system.graph().store().deleteResource(system.registry().log());
            }
            this.removeSumusMetrics(system);
            this.removeIssues(system);
            system.delete$();
        }

        private void removeIssues(Identifiable identifiable) {
            CesarGraph graph = this.box.graph();
            List<IssueReport> reports = graph.issueTracker().issueReportList().stream().filter(issueReport -> ((Object)((Object)issueReport.target())).equals((Object)identifiable)).collect(Collectors.toList());
            reports.forEach(Layer::delete$);
        }

        void removeSumusMetrics(io.intino.cesar.graph.System system) {
            SumusStore store = (SumusStore)this.box.graph().core$().store();
            Instant minInstantForNameSpace = store.minInstantForNameSpace(this.box.graph().default$().name$());
            Instant maxInstantForNameSpace = store.maxInstantForNameSpace(this.box.graph().default$().name$());
            TimeRange range = new TimeRange(minInstantForNameSpace, maxInstantForNameSpace, TimeScale.FifteenMinutes);
            range.allInstants().forEach(i -> {
                Graph clone = this.box.graph().core$().clone();
                String stash = PathBuilder.temporalRecordPath((NameSpace)this.box.graph().default$(), SystemStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)i);
                store.allowWriting(false);
                clone.loadStashes(new String[]{stash});
                new ArrayList<SystemStatus>(((CesarGraph)clone.as(CesarGraph.class)).systemStatusList()).stream().filter(s -> s.system() == null || ((Object)((Object)s.system())).equals((Object)system)).forEach(Layer::delete$);
                store.allowWriting(true);
                clone.save(new String[]{stash});
            });
        }
    }

    public static class Add
    extends InfrastructureHandler {
        private final SystemSchema schema = (SystemSchema)MessageManager.gson().fromJson(this.parameters()[0], SystemSchema.class);

        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            ServerConsul consul = this.findConsulByServer(this.schema.runtime().serverName());
            String name = consul.core$().owner().name() + ":" + Utils.normalizedID(this.schema.name());
            Project project = this.cesar.projectList(p -> p.name$().equals(this.schema.project())).findFirst().orElse(null);
            if (project.systemList().stream().anyMatch(s -> s.name$().equals(name) && ((Object)((Object)s.consul())).equals((Object)consul))) {
                return;
            }
            io.intino.cesar.graph.System newSystem = this.createSystem(project, name);
            String[] split = this.schema.packaging().artifact().split(":");
            Artifact artifact = newSystem.create().artifact(split[0], split[1], split[2]);
            newSystem.create().registry();
            newSystem.create().operations();
            newSystem.operations().port(this.schema.jmxPort());
            newSystem.consul(consul);
            newSystem.debugPort(((Server)newSystem.consul().core$().ownerAs(Server.class)).reserveDebugPort());
            for (Artifactory artifactory : this.schema.artifactoryList()) {
                artifact.create().artifactory(artifactory.url(), artifactory.id());
            }
            newSystem.save$();
        }

        private io.intino.cesar.graph.System createSystem(Project project, String name) {
            return this.schema.tag().contains("Datalake") ? project.create(name).datalake(this.schema.name(), this.schema.publicURL()) : project.create(name).system(this.schema.name(), this.schema.publicURL());
        }

        private ServerConsul findConsulByServer(String serverName) {
            Server server = (Server)((Object)this.box.graph().serverList(u -> u.name$().equals(serverName)).collect(Collectors.toList()).get(0));
            return server.serverConsul();
        }
    }
}

