/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers.infrastructure;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.ServerStatus;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.SumusStore;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Server {

    public static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Server server = this.cesar.server(this.objectID());
            server.label(this.parameters()[0]);
            server.save$();
        }
    }

    public static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Node node = this.cesar.core$().load(this.objectID());
            this.removeIssues((io.intino.cesar.graph.Server)node.as(io.intino.cesar.graph.Server.class));
            this.removeSumusMetrics((io.intino.cesar.graph.Server)node.as(io.intino.cesar.graph.Server.class));
            node.delete();
        }

        private void removeSumusMetrics(io.intino.cesar.graph.Server server) {
            SumusStore store = (SumusStore)this.box.graph().core$().store();
            Instant minInstantForNameSpace = store.minInstantForNameSpace(this.box.graph().default$().name$());
            Instant maxInstantForNameSpace = store.maxInstantForNameSpace(this.box.graph().default$().name$());
            TimeRange range = new TimeRange(minInstantForNameSpace, maxInstantForNameSpace, TimeScale.FifteenMinutes);
            range.allInstants().forEach(i -> {
                Graph clone = this.box.graph().core$().clone();
                String stash = PathBuilder.temporalRecordPath((NameSpace)this.box.graph().default$(), ServerStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)i);
                store.allowWriting(false);
                clone.loadStashes(new String[]{stash});
                new ArrayList<DeviceStatus>(((CesarGraph)clone.as(CesarGraph.class)).deviceStatusList()).stream().filter(d -> d.device() == null || ((Object)((Object)d.device())).equals((Object)server)).forEach(Layer::delete$);
                store.allowWriting(true);
                clone.save(new String[]{stash});
            });
        }

        private void removeIssues(io.intino.cesar.graph.Server server) {
            CesarGraph graph = this.box.graph();
            List<IssueReport> reports = graph.issueTracker().issueReportList().stream().filter(issueReport -> ((Object)((Object)issueReport.target())).equals((Object)server)).collect(Collectors.toList());
            reports.forEach(Layer::delete$);
        }
    }

    public static class Add
    extends InfrastructureHandler {
        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Server server = this.cesar.create("infrastructure/servers/" + this.objectID(), this.objectID()).server(this.objectID(), this.parameters()[0], this.parameters()[1], AbstractServer.Performance.Medium);
            server.create().serverConsul("1.0.0");
            server.save$();
        }
    }
}

