/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers.infrastructure;

import io.intino.cesar.box.MessageManager;
import io.intino.cesar.graph.Datalake;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.System;
import java.time.Instant;
import java.util.Arrays;

public class InfrastructureOperation {
    private final Instant ts = Instant.now();
    private String operation;
    private String user;
    private String objectType;
    private String objectID;
    private String[] parameters;

    public InfrastructureOperation() {
    }

    public InfrastructureOperation(String operation, String user, String objectType, String objectID, String[] parameters) {
        this.operation = operation;
        this.user = user;
        this.objectType = objectType;
        this.objectID = objectID;
        this.parameters = parameters;
    }

    public Instant ts() {
        return this.ts;
    }

    public String operation() {
        return this.operation;
    }

    public String user() {
        return this.user;
    }

    public String objectType() {
        return this.objectType;
    }

    public String objectID() {
        return this.objectID;
    }

    public String[] parameters() {
        return this.parameters;
    }

    public static String message(String operation, String user, Identifiable identifiable, String ... parameters) {
        return MessageManager.toInl(new InfrastructureOperation(operation, user, ((Object)((Object)identifiable)).getClass().equals(Datalake.class) ? System.class.getSimpleName().toLowerCase() : ((Object)((Object)identifiable)).getClass().getSimpleName().toLowerCase(), identifiable.core$().id(), parameters));
    }

    public static String message(String operation, String user, String identifiable, String objectId, String ... parameters) {
        return MessageManager.toInl(new InfrastructureOperation(operation, user, identifiable, objectId, parameters));
    }

    public String toString() {
        return "InfrastructureOperation{operation='" + this.operation + '\'' + ", user='" + this.user + '\'' + ", objectType='" + this.objectType + '\'' + ", objectID='" + this.objectID + '\'' + ", parameters=" + Arrays.toString(this.parameters) + '}';
    }
}

