/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers.infrastructure;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.rules.Issue;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.SumusStore;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Device {

    public static class SetNotifications
    extends InfrastructureHandler {
        public SetNotifications(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = this.cesar.device(this.objectID());
            ArrayList<Issue> list = new ArrayList<Issue>();
            if ("true".equals(this.parameters()[0])) {
                list.add(Issue.Unplugged);
            }
            if ("true".equals(this.parameters()[1])) {
                list.add(Issue.HighTemperature);
            }
            if ("true".equals(this.parameters()[2])) {
                list.add(Issue.LowBattery);
            }
            if ("true".equals(this.parameters()[3])) {
                list.add(Issue.VeryLowBattery);
            }
            if ("true".equals(this.parameters()[4])) {
                list.add(Issue.Disconnected);
            }
            device.activeIssueSensors().clear();
            device.activeIssueSensors().addAll(list);
            device.save$();
        }
    }

    public static class Upgrade
    extends InfrastructureHandler {
        public Upgrade(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = this.cesar.device(this.objectID());
            device.consul().version(this.parameters()[0]);
            device.save$();
        }
    }

    public static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = this.cesar.device(this.objectID());
            device.label(this.parameters()[0]);
            device.save$();
        }
    }

    public static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Node node = this.cesar.core$().load(this.objectID());
            this.removeSumusMetrics((io.intino.cesar.graph.Device)node.as(io.intino.cesar.graph.Device.class));
            this.removeIssues((io.intino.cesar.graph.Device)node.as(io.intino.cesar.graph.Device.class));
            node.delete();
        }

        private void removeIssues(io.intino.cesar.graph.Device device) {
            CesarGraph graph = this.box.graph();
            List<IssueReport> reports = graph.issueTracker().issueReportList().stream().filter(issueReport -> ((Object)((Object)issueReport.target())).equals((Object)device)).collect(Collectors.toList());
            reports.forEach(Layer::delete$);
        }

        private void removeSumusMetrics(io.intino.cesar.graph.Device device) {
            SumusStore store = (SumusStore)this.box.graph().core$().store();
            Instant minInstantForNameSpace = store.minInstantForNameSpace(this.box.graph().default$().name$());
            Instant maxInstantForNameSpace = store.maxInstantForNameSpace(this.box.graph().default$().name$());
            TimeRange range = new TimeRange(minInstantForNameSpace, maxInstantForNameSpace, TimeScale.FifteenMinutes);
            range.allInstants().forEach(i -> {
                Graph clone = this.box.graph().core$().clone();
                String stash = PathBuilder.temporalRecordPath((NameSpace)this.box.graph().default$(), DeviceStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)i);
                store.allowWriting(false);
                clone.loadStashes(new String[]{stash});
                new ArrayList<DeviceStatus>(((CesarGraph)clone.as(CesarGraph.class)).deviceStatusList()).stream().filter(d -> d.device() == null || ((Object)((Object)d.device())).equals((Object)device)).forEach(Layer::delete$);
                store.allowWriting(true);
                clone.save(new String[]{stash});
            });
        }
    }

    public static class Add
    extends InfrastructureHandler {
        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = this.cesar.create("infrastructure/devices/" + this.objectID(), this.objectID()).device(this.parameters()[0]);
            device.create().consul("1.0.0");
            device.create().screen(null);
            device.create().temperature(0.0, 0.0);
            try {
                device.save$();
            }
            catch (Exception e) {
                Logger.getGlobal().severe(e.getMessage());
            }
        }
    }
}

