/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.checkers.SystemStatusChecker;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemDigest;
import io.intino.cesar.graph.SystemStatus;
import io.intino.konos.alexandria.Inl;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.ness.inl.Message;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.Arrays;

public class SystemStatusMessageHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        io.intino.consul.schemas.SystemStatus status = (io.intino.consul.schemas.SystemStatus)Inl.deserialize((String)this.message.toString()).next(io.intino.consul.schemas.SystemStatus.class);
        System system = this.findSystem(status);
        if (system == null) {
            return;
        }
        system.started(status.started());
        if (system.started()) {
            this.createEvent(system, status);
            this.createDigests(system, status);
        }
        system.save$();
        new SystemStatusChecker(system, this.box).check();
        ((SumusBox)this.box.owner()).refreshDisplaysOf((Catalog)Displays.displayFor(this.box, "systemCatalog").element(), false, new Item[]{new Item().id(system.core$().id()).name(system.name$()).object((Object)system)});
    }

    private void createEvent(System system, io.intino.consul.schemas.SystemStatus status) {
        CesarGraph clone = (CesarGraph)system.graph().core$().clone().as(CesarGraph.class);
        SystemStatus systemStatus = this.getOrCreateStatus(system, status, clone);
        systemStatus.save$();
        system.statusRef(systemStatus.core$().id());
        system.status(systemStatus);
    }

    private SystemStatus getOrCreateStatus(System system, io.intino.consul.schemas.SystemStatus status, CesarGraph clone) {
        String stash = PathBuilder.temporalRecordPath((NameSpace)clone.default$(), SystemStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)status.ts());
        Node node = clone.core$().load(stash + "#" + system.name$(), false);
        if (node == null) {
            return clone.create(stash, system.name$()).systemStatus(system, status.cpu(), status.memory(), status.threads(), status.ts());
        }
        SystemStatus core = (SystemStatus)node.as(SystemStatus.class);
        return core.cpuUsage(status.cpu()).memoryUsage(status.memory()).threads(status.threads()).created(status.ts());
    }

    private void createDigests(System system, io.intino.consul.schemas.SystemStatus status) {
        for (TimeScale scale : Arrays.asList(TimeScale.FifteenMinutes, TimeScale.Hour, TimeScale.SixHours, TimeScale.Day, TimeScale.Week, TimeScale.Month, TimeScale.QuarterOfYear, TimeScale.Year)) {
            this.fill(this.digestOf(system, scale, status.ts()), status);
        }
    }

    private void fill(Digest digest, io.intino.consul.schemas.SystemStatus status) {
        new SystemDigest(digest).addCount().addUsedCPU(status.cpu()).addUsedMemory(status.memory()).addThreads(status.threads()).save();
    }

    private Digest digestOf(System system, TimeScale scale, Instant ts) {
        return system.graph().systemCube().getOrCreateBucket(system.graph().default$(), scale, ts).digest(new String[]{system.core$().id()});
    }

    private System findSystem(io.intino.consul.schemas.SystemStatus status) {
        return this.box.graph().systemFrom(status.project(), status.id(), status.serverID());
    }
}

