/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.CesarSystemLog;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.rules.Issue;
import io.intino.consul.schemas.SystemLog;
import io.intino.konos.alexandria.Inl;
import io.intino.ness.inl.Message;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SystemLogMessageHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        SystemLog systemLog = (SystemLog)Inl.deserialize((String)this.message.toString()).next(SystemLog.class);
        System system = this.box.graph().systemFrom(systemLog.project(), systemLog.id(), systemLog.serverId());
        if (system == null) {
            return;
        }
        List<Message> messages = this.checkSystemLog(system, systemLog);
        if (system.registry().log() == null || !new File(system.registry().log().getFile()).exists()) {
            this.createLog(systemLog, system, messages);
        } else {
            this.appendLog(systemLog, system, messages);
        }
        this.box.souls().stream().map(s -> s.displays(CesarSystemLog.class)).flatMap(Collection::stream).filter(d -> system.core$().id().equals(d.item().id())).forEach(CesarSystemLog::refresh);
    }

    private void createLog(SystemLog systemLog, System system, List<Message> messages) {
        system.registry().log(new ByteArrayInputStream(messages.isEmpty() ? (systemLog.value() + "\n").getBytes() : this.bytesOf(messages)), this.destination(system, systemLog)).save$();
    }

    private List<Message> checkSystemLog(System system, SystemLog systemLog) {
        if (!this.isInl(systemLog.value())) {
            return Collections.emptyList();
        }
        List messages = Inl.load((String)systemLog.value());
        this.transformToInstant(messages);
        for (Message message : messages) {
            message.type("log");
            Log log = this.deserialize(message);
            if (log == null || !log.level.equalsIgnoreCase("error") && !log.level.equalsIgnoreCase("severe") && !log.level.equalsIgnoreCase("warning")) continue;
            Issue issue = this.createIssue(system, log);
            issue.execCounterMeasures(this.box, system);
        }
        return messages;
    }

    private void appendLog(SystemLog systemLog, System system, List<Message> messages) {
        try {
            Files.write(new File(system.registry().log().getFile()).toPath(), messages.isEmpty() ? (systemLog.value() + "\n").getBytes() : this.bytesOf(messages), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            Logger.getRootLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private byte[] bytesOf(List<Message> messages) {
        return messages.stream().map(m -> m + "\n").collect(Collectors.joining()).getBytes();
    }

    private Log deserialize(Message message) {
        try {
            return (Log)Inl.deserialize((String)message.toString()).next(Log.class);
        }
        catch (RuntimeException e) {
            Logger.getRootLogger().error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void transformToInstant(List<Message> messages) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        for (Message message : messages) {
            try {
                String ts;
                if (message.contains("created")) {
                    message.rename("created", "ts");
                }
                if (this.isInstantFormat(ts = message.get("ts"))) continue;
                message.set("ts", simpleDateFormat.parse(ts).toInstant().toString());
            }
            catch (Exception e) {
                Logger.getRootLogger().error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isInstantFormat(String ts) {
        try {
            return Instant.parse(ts) != null;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private boolean isInl(String value) {
        return value.contains("\n") && value.substring(0, value.indexOf("\n")).matches("\\[.*]");
    }

    private Issue createIssue(System system, Log log) {
        for (IssueReport issue : this.box.graph().issueTracker().issueReportList()) {
            if (!this.isRepeated(log, system, issue)) continue;
            issue.count(issue.count() + 1);
            issue.save$();
            return Issue.LogError;
        }
        IssueReport issueReport = this.box.graph().issueTracker().create().issueReport(system, IssueReport.Level.valueOf(StringUtils.capitalize((String)log.level.toLowerCase())), Issue.LogError);
        issueReport.create().log(log.sourceClass, log.sourceMethod, log.message);
        issueReport.save$();
        return Issue.LogError;
    }

    private boolean isRepeated(Log log, System system, IssueReport issue) {
        return ((Object)((Object)issue.target())).equals((Object)system) && issue.level().name().equalsIgnoreCase(log.level) && issue.log().sourceClass().equals(log.sourceClass) && issue.log().sourceMethod().equals(log.sourceMethod);
    }

    private String destination(System system, SystemLog systemLog) {
        return "projects/" + systemLog.project() + "/" + system.core$().name().replaceFirst(":", "_") + ".log";
    }

    public static class Log {
        Instant ts;
        String level;
        String sourceClass;
        String sourceMethod;
        String message;
    }
}

