/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.checkers.ServerStatusChecker;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerDigest;
import io.intino.cesar.graph.ServerStatus;
import io.intino.konos.alexandria.Inl;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.ness.inl.Message;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.Arrays;

public class ServerStatusMessageHandler {
    public CesarBox box;
    public Message message;
    private Server server;

    public void execute() {
        io.intino.consul.schemas.ServerStatus status = (io.intino.consul.schemas.ServerStatus)Inl.deserialize((String)this.message.toString()).next(io.intino.consul.schemas.ServerStatus.class);
        this.server = this.findServer(status.id());
        if (this.server == null) {
            return;
        }
        this.createEvent(status);
        this.createDigests(status);
        new ServerStatusChecker(this.server, this.box).check();
    }

    private void createEvent(io.intino.consul.schemas.ServerStatus status) {
        CesarGraph clone = (CesarGraph)this.server.graph().core$().clone().as(CesarGraph.class);
        ServerStatus serverStatus = this.getOrCreateStatus(status, clone);
        serverStatus.save$();
        this.server.status(serverStatus);
        this.server.save$();
    }

    private ServerStatus getOrCreateStatus(io.intino.consul.schemas.ServerStatus status, CesarGraph clone) {
        String stash = PathBuilder.temporalRecordPath((NameSpace)clone.default$(), ServerStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)status.ts());
        String name = this.server.name$();
        Node node = clone.core$().load(stash + "#" + name, false);
        if (node == null) {
            return clone.create(stash, name).serverStatus(this.server, status.cpu(), status.memory(), status.hdd(), status.inboundConnections(), status.outboundConnections(), status.ts());
        }
        return ((ServerStatus)node.as(ServerStatus.class)).cpuUsage(status.cpu()).memoryUsage(status.memory()).diskUsage(status.hdd()).inboundConnections(status.inboundConnections()).inboundConnections(status.outboundConnections()).created(status.ts());
    }

    private void createDigests(io.intino.consul.schemas.ServerStatus status) {
        for (TimeScale scale : Arrays.asList(TimeScale.FifteenMinutes, TimeScale.Hour, TimeScale.SixHours, TimeScale.Day, TimeScale.Week, TimeScale.Month, TimeScale.QuarterOfYear, TimeScale.Year)) {
            this.fill(this.digestOf(this.server, scale, status.ts()), status);
        }
    }

    private void fill(Digest digest, io.intino.consul.schemas.ServerStatus status) {
        new ServerDigest(digest).addCount().addUsedCPU(status.cpu()).addUsedMemory(status.memory()).addUsedDisk(status.hdd()).addInboundConnections(status.inboundConnections()).addOutboundConnections(status.outboundConnections()).save();
    }

    private Digest digestOf(Server server, TimeScale scale, Instant ts) {
        return server.graph().serverCube().getOrCreateBucket(server.graph().default$(), scale, ts).digest(new String[]{server.core$().id()});
    }

    private Server findServer(String name) {
        return this.box.graph().serverList(unit -> unit.name$().equals(name)).findFirst().orElse(null);
    }
}

