/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Asset;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Device;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Feeder;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Identifiable;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Infrastructure;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Server;
import io.intino.cesar.box.ness.messagehandlers.projects.Project;
import io.intino.cesar.box.ness.messagehandlers.projects.System;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class HandlerFactory {
    private static Map<String, HandlerCreator> handlerMap = new HashMap<String, HandlerCreator>();

    public static InfrastructureHandler get(CesarBox box, InfrastructureOperation operation) {
        try {
            return handlerMap.get((operation.operation() + ";" + operation.objectType()).toLowerCase()).build(box, operation);
        }
        catch (Exception e) {
            Logger.getRootLogger().error((Object)("Error handling event. " + operation.toString() + "." + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static {
        handlerMap.put("add;device", Device.Add::new);
        handlerMap.put("add;system", System.Add::new);
        handlerMap.put("add;server", Server.Add::new);
        handlerMap.put("add;feeder", Feeder.Add::new);
        handlerMap.put("add;project", Project.Add::new);
        handlerMap.put("remove;device", Device.Remove::new);
        handlerMap.put("remove;feeder", Feeder.Remove::new);
        handlerMap.put("remove;system", System.Remove::new);
        handlerMap.put("remove;server", Server.Remove::new);
        handlerMap.put("remove;project", Project.Remove::new);
        handlerMap.put("rename;device", Device.Rename::new);
        handlerMap.put("rename;system", System.Rename::new);
        handlerMap.put("rename;server", Server.Rename::new);
        handlerMap.put("rename;feeder", Feeder.Rename::new);
        handlerMap.put("rename;project", Project.Rename::new);
        handlerMap.put("upgrade;device", Device.Upgrade::new);
        handlerMap.put("setnotifications;device", Device.SetNotifications::new);
        handlerMap.put("newdeployment;system", System.NewDeployment::new);
        handlerMap.put("changeparameter;system", System.ChangeParameter::new);
        handlerMap.put("changestatus;system", System.ChangeStatus::new);
        handlerMap.put("assignproject;server", Asset.AssignProject::new);
        handlerMap.put("assignproject;device", Asset.AssignProject::new);
        handlerMap.put("assignproject;feeder", Asset.AssignProject::new);
        handlerMap.put("setresponsibles;system", Identifiable.SetResponsibles::new);
        handlerMap.put("setresponsibles;server", Identifiable.SetResponsibles::new);
        handlerMap.put("setresponsibles;feeder", Identifiable.SetResponsibles::new);
        handlerMap.put("setresponsibles;device", Identifiable.SetResponsibles::new);
        handlerMap.put("add;responsible", Infrastructure.AddResponsible::new);
        handlerMap.put("notifications;configuration", Infrastructure.NotificationsConfiguration::new);
        handlerMap.put("remove;responsible", Infrastructure.RemoveResponsible::new);
    }

    private static interface HandlerCreator {
        public InfrastructureHandler build(CesarBox var1, InfrastructureOperation var2);
    }
}

