/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.checkers.FeederStatusChecker;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.FeederStatus;
import io.intino.cesar.graph.ServerStatus;
import io.intino.konos.alexandria.Inl;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.ness.inl.Message;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Node;
import java.time.Instant;

public class FeederStatusMessageHandler {
    public CesarBox box;
    public Message message;
    private Feeder feeder;

    public void execute() {
        io.intino.consul.schemas.ServerStatus status = (io.intino.consul.schemas.ServerStatus)Inl.deserialize((String)this.message.toString()).next(io.intino.consul.schemas.ServerStatus.class);
        this.feeder = this.findFeeder(status.id());
        if (this.feeder == null) {
            return;
        }
        this.createEvent(status);
        new FeederStatusChecker(this.feeder, this.box).check();
    }

    private void createEvent(io.intino.consul.schemas.ServerStatus status) {
        CesarGraph clone = (CesarGraph)this.feeder.graph().core$().clone().as(CesarGraph.class);
        FeederStatus feederStatus = this.getOrCreateStatus(status, clone);
        feederStatus.save$();
        this.feeder.status(feederStatus);
        this.feeder.save$();
    }

    private FeederStatus getOrCreateStatus(io.intino.consul.schemas.ServerStatus status, CesarGraph clone) {
        String stash = PathBuilder.temporalRecordPath((NameSpace)clone.default$(), ServerStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)status.ts());
        String name = this.feeder.name$();
        Node node = clone.core$().load(stash + "#" + name, false);
        if (node == null) {
            return clone.create(stash, name).feederStatus(status.cpu(), status.memory(), status.hdd(), status.inboundConnections(), status.outboundConnections(), this.feeder, status.temperature(), status.ts());
        }
        return (FeederStatus)((FeederStatus)node.as(FeederStatus.class)).temperature(status.temperature()).cpuUsage(status.cpu()).memoryUsage(status.memory()).diskUsage(status.hdd()).inboundConnections(status.inboundConnections()).inboundConnections(status.outboundConnections()).created(status.ts()).a$(FeederStatus.class);
    }

    private Feeder findFeeder(String name) {
        return this.box.graph().feederList(unit -> unit.name$().equals(name)).findFirst().orElse(null);
    }
}

