/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.Device;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.konos.alexandria.Inl;
import io.intino.ness.inl.Message;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceUpgradeMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        CommandExecuted command = (CommandExecuted)Inl.deserialize((String)this.upgradeMessage(this.message).toString()).next(CommandExecuted.class);
        if (command.remarks().isEmpty()) {
            new Device.Upgrade(this.box, this.newOperation(command)).execute();
        }
        this.notify(command, this.findDevice(this.box, command.deviceId()));
    }

    private InfrastructureOperation newOperation(CommandExecuted command) {
        return new InfrastructureOperation("upgrade", "cesar", "device", command.deviceId(), new String[]{command.consulVersion()});
    }

    private void notify(CommandExecuted command, Device device) {
        List<Responsible> developers = this.developers(device);
        String slackUser = this.box.slackLastActionUser();
        EventNotifier notifier = new EventNotifier(this.box);
        if (slackUser != null && !this.isDeveloper(developers, slackUser)) {
            notifier.notify(slackUser, device.label() + "> ", command.remarks());
        }
        if (this.box.graph().configuration().notifications()) {
            notifier.notify(developers, device.label() + "> ", command.remarks());
        }
    }

    private boolean isDeveloper(List<Responsible> developers, String slackUser) {
        return developers.stream().anyMatch(developer -> developer.asSlackContact().slackChannel().equals(slackUser));
    }

    private List<Responsible> developers(Device device) {
        return device.responsibles().stream().filter(Responsible::isSlackContact).collect(Collectors.toList());
    }

    private Message upgradeMessage(Message message) {
        if (message.attributes().contains("created")) {
            DeviceUpgradeMessageHandler.removeCreatedAttribute(message);
        }
        return message;
    }

    private static void removeCreatedAttribute(Message message) {
        Instant created = (Instant)message.read("created").as(Instant.class);
        message.set("ts", created.toString());
        message.remove("created");
    }
}

