/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.ness.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.checkers.DeviceStatusChecker;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceDigest;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.konos.alexandria.Inl;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.ness.inl.Message;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.Arrays;

public class DeviceStatusMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        this.message = this.upgradeMessage(this.message);
        Status status = (Status)Inl.deserialize((String)this.upgradeMessage(this.message).toString()).next(Status.class);
        Device device = this.findDevice(this.box, status.deviceId());
        if (device == null) {
            return;
        }
        this.createEvent(device, status);
        this.createDigests(device, status);
        new DeviceStatusChecker(device, this.box).check();
        device.update(d -> ((SumusBox)this.box.owner()).refreshDisplaysOf((Catalog)Displays.displayFor(this.box, "deviceCatalog").element(), false, new Item[]{new Item().id(d.core$().id()).name(d.name$()).object((Object)d)}));
    }

    private void createEvent(Device device, Status status) {
        CesarGraph clone = (CesarGraph)device.graph().core$().clone().as(CesarGraph.class);
        DeviceStatus deviceStatus = this.getOrCreateStatus(device, status, clone);
        deviceStatus.save$();
        device.status(deviceStatus);
        device.save$();
    }

    private DeviceStatus getOrCreateStatus(Device device, Status status, CesarGraph clone) {
        String stash = PathBuilder.temporalRecordPath((NameSpace)clone.default$(), DeviceStatus.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)status.ts());
        String name = device.name$();
        Node node = clone.core$().load(stash + "#" + name, false);
        if (node == null) {
            return clone.create(stash, name).deviceStatus(device, status.temperature(), status.battery(), status.cpuUsage(), status.isPlugged(), status.isScreenOn(), status.consulVersion(), status.ts());
        }
        return ((DeviceStatus)node.as(DeviceStatus.class)).temperature(status.temperature()).battery(status.battery()).cpuUsage(status.cpuUsage()).isPlugged(status.isPlugged()).isScreenOn(status.isScreenOn()).consulVersion(status.consulVersion()).created(status.ts());
    }

    private void createDigests(Device device, Status status) {
        for (TimeScale scale : Arrays.asList(TimeScale.FifteenMinutes, TimeScale.Hour, TimeScale.SixHours, TimeScale.Day, TimeScale.Week, TimeScale.Month, TimeScale.QuarterOfYear, TimeScale.Year)) {
            this.fill(this.digestOf(device, scale, status.ts()), status);
        }
    }

    private void fill(Digest digest, Status status) {
        new DeviceDigest(digest).addCount().addBattery(status.battery()).addCpuUsage(status.cpuUsage()).addIsPlugged(status.isPlugged()).addIsScreenOn(status.isScreenOn()).addTemperature(status.temperature()).save();
    }

    private Digest digestOf(Device device, TimeScale scale, Instant ts) {
        return device.graph().deviceCube().getOrCreateBucket(device.graph().default$(), scale, ts).digest(new String[]{device.core$().id()});
    }

    private Message upgradeMessage(Message message) {
        if (message.attributes().contains("created")) {
            DeviceStatusMessageHandler.removeCreatedAttribute(message);
        }
        if (message.get("ts") == null) {
            message.set("ts", Instant.now().toString());
        }
        return message;
    }

    private static void removeCreatedAttribute(Message message) {
        Instant created = (Instant)message.read("created").as(Instant.class);
        message.set("ts", created.toString());
        message.remove("created");
    }
}

