/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.schemas.Boot;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceBoot;
import io.intino.konos.alexandria.Inl;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.ness.inl.Message;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.NameSpace;
import java.time.Instant;

public class DeviceBootMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        Boot boot = (Boot)Inl.deserialize((String)this.upgradeMessage(this.message).toString()).next(Boot.class);
        Device device = this.findDevice(this.box, boot.deviceId());
        if (device != null) {
            this.createEvent(device, boot);
        }
    }

    private void createEvent(Device device, Boot boot) {
        CesarGraph clone = (CesarGraph)device.graph().core$().clone().as(CesarGraph.class);
        DeviceBoot deviceBoot = clone.create(PathBuilder.temporalRecordPath((NameSpace)clone.default$(), DeviceBoot.class, (TimeScale)TimeScale.FifteenMinutes, (Instant)boot.ts())).deviceBoot(device, boot.consulVersion(), boot.ts());
        deviceBoot.save$();
        device.save$();
    }

    private Message upgradeMessage(Message message) {
        if (message.attributes().contains("created")) {
            DeviceBootMessageHandler.removeCreatedAttribute(message);
        }
        return message;
    }

    private static void removeCreatedAttribute(Message message) {
        Instant created = (Instant)message.read("created").as(Instant.class);
        message.set("ts", created.toString());
        message.remove("created");
    }
}

