/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.CesarStore;
import io.intino.konos.datalake.Ness;
import io.intino.tara.magritte.Graph;
import java.util.Collections;
import java.util.List;
import org.quartz.SchedulerException;

class ReflowAssistant {
    private final CesarBox box;

    ReflowAssistant(CesarBox box) {
        this.box = box;
    }

    void before() {
        EventNotifier.ACTIVE = false;
        try {
            this.box.tasker().shutdownSchedules();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    int blockSize() {
        return 50000;
    }

    List<Ness.Tank> tanks() {
        return Collections.singletonList(NessTanks.infrastructureOperation());
    }

    Graph graph() {
        return this.box.graph().core$();
    }

    String[] coreStashes() {
        ((CesarStore)this.box.graph().core$().store()).firstLoad(true);
        return new String[]{"Cesar", "Configuration", "Responsibles", "Systems", "IssueTracker"};
    }

    void saveGraph(Graph graph) {
        graph.saveAll(new String[]{"Model", "Cesar"});
    }

    void after() {
        EventNotifier.ACTIVE = true;
    }
}

