/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.ness;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ness.messagehandlers.DeviceBootMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.DeviceCrashMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.DeviceStatusMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.DeviceUpgradeMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.FeederLogMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.FeederStatusMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.FeederUpgradeMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.InfrastructureOperationMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.ServerLogMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.ServerStatusMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.ServerUpgradeMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.SystemLogMessageHandler;
import io.intino.cesar.box.ness.messagehandlers.SystemStatusMessageHandler;
import io.intino.konos.datalake.MessageDispatcher;
import io.intino.konos.datalake.Ness;
import io.intino.konos.jms.Consumer;
import io.intino.ness.inl.Message;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;

public class NessTanks
implements MessageDispatcher {
    private static Ness.Tank infrastructureOperation;
    private static Ness.Tank serverStatus;
    private static Ness.Tank serverLog;
    private static Ness.Tank serverUpgrade;
    private static Ness.Tank feederStatus;
    private static Ness.Tank feederLog;
    private static Ness.Tank feederUpgrade;
    private static Ness.Tank deviceStatus;
    private static Ness.Tank deviceBoot;
    private static Ness.Tank deviceUpgrade;
    private static Ness.Tank deviceCrash;
    private static Ness.Tank systemLog;
    private static Ness.Tank systemStatus;
    private static Map<String, Ness.TankFlow> handlersMap;

    public static void registerTanks(CesarBox box) {
        infrastructureOperation = box.datalake().tank("cesar.infrastructure.operation");
        handlersMap.put("operation", new InfrastructureOperationSubscriptor(box));
        serverStatus = box.datalake().tank("consul.server.status");
        handlersMap.put("status", new ServerStatusSubscriptor(box));
        serverLog = box.datalake().tank("consul.server.log");
        handlersMap.put("log", new ServerLogSubscriptor(box));
        serverUpgrade = box.datalake().tank("consul.server.upgrade");
        handlersMap.put("upgrade", new ServerUpgradeSubscriptor(box));
        feederStatus = box.datalake().tank("consul.feeder.status");
        handlersMap.put("status", new FeederStatusSubscriptor(box));
        feederLog = box.datalake().tank("consul.feeder.log");
        handlersMap.put("log", new FeederLogSubscriptor(box));
        feederUpgrade = box.datalake().tank("consul.feeder.upgrade");
        handlersMap.put("upgrade", new FeederUpgradeSubscriptor(box));
        deviceStatus = box.datalake().tank("consul.device.status");
        handlersMap.put("status", new DeviceStatusSubscriptor(box));
        deviceBoot = box.datalake().tank("consul.device.boot");
        handlersMap.put("boot", new DeviceBootSubscriptor(box));
        deviceUpgrade = box.datalake().tank("consul.device.upgrade");
        handlersMap.put("upgrade", new DeviceUpgradeSubscriptor(box));
        deviceCrash = box.datalake().tank("consul.device.crash");
        handlersMap.put("crash", new DeviceCrashSubscriptor(box));
        systemLog = box.datalake().tank("consul.system.log");
        handlersMap.put("log", new SystemLogSubscriptor(box));
        systemStatus = box.datalake().tank("consul.system.status");
        handlersMap.put("status", new SystemStatusSubscriptor(box));
        String clientID = box.configuration().nessConfiguration().clientID;
        infrastructureOperation.flow((Ness.TankFlow)new InfrastructureOperationSubscriptor(box), clientID != null ? clientID + "-infrastructureOperation" : null);
        serverStatus.flow((Ness.TankFlow)new ServerStatusSubscriptor(box), clientID != null ? clientID + "-serverStatus" : null);
        serverLog.flow((Ness.TankFlow)new ServerLogSubscriptor(box), clientID != null ? clientID + "-serverLog" : null);
        serverUpgrade.flow((Ness.TankFlow)new ServerUpgradeSubscriptor(box), clientID != null ? clientID + "-serverUpgrade" : null);
        feederStatus.flow((Ness.TankFlow)new FeederStatusSubscriptor(box), clientID != null ? clientID + "-feederStatus" : null);
        feederLog.flow((Ness.TankFlow)new FeederLogSubscriptor(box), clientID != null ? clientID + "-feederLog" : null);
        feederUpgrade.flow((Ness.TankFlow)new FeederUpgradeSubscriptor(box), clientID != null ? clientID + "-feederUpgrade" : null);
        deviceStatus.flow((Ness.TankFlow)new DeviceStatusSubscriptor(box), clientID != null ? clientID + "-deviceStatus" : null);
        deviceBoot.flow((Ness.TankFlow)new DeviceBootSubscriptor(box), clientID != null ? clientID + "-deviceBoot" : null);
        deviceUpgrade.flow((Ness.TankFlow)new DeviceUpgradeSubscriptor(box), clientID != null ? clientID + "-deviceUpgrade" : null);
        deviceCrash.flow((Ness.TankFlow)new DeviceCrashSubscriptor(box), clientID != null ? clientID + "-deviceCrash" : null);
        systemLog.flow((Ness.TankFlow)new SystemLogSubscriptor(box), clientID != null ? clientID + "-systemLog" : null);
        systemStatus.flow((Ness.TankFlow)new SystemStatusSubscriptor(box), clientID != null ? clientID + "-systemStatus" : null);
    }

    public void dispatch(Message message) {
        handlersMap.get(message.type().toLowerCase()).consume(message);
    }

    public static Ness.Tank infrastructureOperation() {
        return infrastructureOperation;
    }

    public static Ness.Tank serverStatus() {
        return serverStatus;
    }

    public static Ness.Tank serverLog() {
        return serverLog;
    }

    public static Ness.Tank serverUpgrade() {
        return serverUpgrade;
    }

    public static Ness.Tank feederStatus() {
        return feederStatus;
    }

    public static Ness.Tank feederLog() {
        return feederLog;
    }

    public static Ness.Tank feederUpgrade() {
        return feederUpgrade;
    }

    public static Ness.Tank deviceStatus() {
        return deviceStatus;
    }

    public static Ness.Tank deviceBoot() {
        return deviceBoot;
    }

    public static Ness.Tank deviceUpgrade() {
        return deviceUpgrade;
    }

    public static Ness.Tank deviceCrash() {
        return deviceCrash;
    }

    public static Ness.Tank systemLog() {
        return systemLog;
    }

    public static Ness.Tank systemStatus() {
        return systemStatus;
    }

    public static void unregister() {
        infrastructureOperation.unregister();
        serverStatus.unregister();
        serverLog.unregister();
        serverUpgrade.unregister();
        feederStatus.unregister();
        feederLog.unregister();
        feederUpgrade.unregister();
        deviceStatus.unregister();
        deviceBoot.unregister();
        deviceUpgrade.unregister();
        deviceCrash.unregister();
        systemLog.unregister();
        systemStatus.unregister();
    }

    private static boolean isRegisterOnly(javax.jms.Message message) {
        try {
            return message.getBooleanProperty("registerOnly");
        }
        catch (JMSException e) {
            return false;
        }
    }

    static {
        handlersMap = new HashMap<String, Ness.TankFlow>();
    }

    private static class SystemStatusSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        SystemStatusSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            SystemStatusMessageHandler tank = new SystemStatusMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class SystemLogSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        SystemLogSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            SystemLogMessageHandler tank = new SystemLogMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class DeviceCrashSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        DeviceCrashSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            DeviceCrashMessageHandler tank = new DeviceCrashMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class DeviceUpgradeSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        DeviceUpgradeSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            DeviceUpgradeMessageHandler tank = new DeviceUpgradeMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class DeviceBootSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        DeviceBootSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            DeviceBootMessageHandler tank = new DeviceBootMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class DeviceStatusSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        DeviceStatusSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            DeviceStatusMessageHandler tank = new DeviceStatusMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class FeederUpgradeSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        FeederUpgradeSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            FeederUpgradeMessageHandler tank = new FeederUpgradeMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class FeederLogSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        FeederLogSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            FeederLogMessageHandler tank = new FeederLogMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class FeederStatusSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        FeederStatusSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            FeederStatusMessageHandler tank = new FeederStatusMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class ServerUpgradeSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        ServerUpgradeSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            ServerUpgradeMessageHandler tank = new ServerUpgradeMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class ServerLogSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        ServerLogSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            ServerLogMessageHandler tank = new ServerLogMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class ServerStatusSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        ServerStatusSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            ServerStatusMessageHandler tank = new ServerStatusMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }

    private static class InfrastructureOperationSubscriptor
    implements Ness.TankFlow {
        private final CesarBox box;

        InfrastructureOperationSubscriptor(CesarBox box) {
            this.box = box;
        }

        public void consume(javax.jms.Message message) {
            if (NessTanks.isRegisterOnly(message)) {
                return;
            }
            this.consume(Message.load((String)Consumer.textFrom((javax.jms.Message)message)));
        }

        public void consume(Message m) {
            this.box.datalake().lastMessage(Instant.now());
            InfrastructureOperationMessageHandler tank = new InfrastructureOperationMessageHandler();
            tank.box = this.box;
            tank.message = m;
            tank.execute();
        }
    }
}

