/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractSystemPreviewMold;
import io.intino.cesar.graph.System;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.time.Instant;

public class SystemPreviewMold
extends AbstractSystemPreviewMold {
    public SystemPreviewMold(CesarBox box) {
        super(box);
    }

    public static class Stamps {

        public static class TimeIcon {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.status() == null || system.isStopped() ? null : "device:access-time";
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                return system.isStopped() ? "color:red;" : "color:green;";
            }

            public static String title(CesarBox box, System system, ActivitySession session) {
                if (system.status() == null || system.isStopped()) {
                    return null;
                }
                Instant instant = system.status().created();
                return String.format("date(%s,LLL)", instant.toEpochMilli());
            }
        }

        public static class Threads {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.status() == null || system.isStopped() ? null : "device:usb";
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                return "color:green;";
            }

            public static String title(CesarBox box, System system, ActivitySession session) {
                if (system.status() == null || system.isStopped()) {
                    return "";
                }
                return String.valueOf(system.status().threads()) + " threads";
            }
        }

        public static class Memory {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.status() == null || system.isStopped() ? "" : "hardware:memory";
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                if (system.status() == null) {
                    return "";
                }
                return system.isRunningOutOfMemory(null) ? "color:red;" : "color:green;";
            }

            public static String title(CesarBox box, System system, ActivitySession session) {
                return system.status() == null ? "" : "memory: " + String.valueOf(system.status().memoryUsage()) + " mb";
            }
        }

        public static class CpuIcon {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.status() == null || system.isStopped() ? null : "icons:work";
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                if (system.status() == null) {
                    return "";
                }
                return !system.isRunningOutOfCpu(null) ? "color:green;" : "color:red;";
            }

            public static String title(CesarBox box, System system, ActivitySession session) {
                return system.status() == null ? "" : "cpu load: " + String.valueOf(system.status().cpuUsage()) + " %";
            }
        }

        public static class Stopped {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.isStopped() ? "warning" : null;
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, System system, ActivitySession session) {
                return "";
            }
        }

        public static class Name {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.label();
            }
        }
    }
}

