/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.notifiers.SystemLoadNotifier;
import io.intino.cesar.box.schemas.SystemLoadMetrics;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemStatus;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.queries.temporalrecord.Query;
import io.intino.sumus.queries.temporalrecord.QueryExecutor;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SystemLoad
extends AlexandriaStamp<SystemLoadNotifier> {
    public SystemLoad(CesarBox box) {
    }

    public void init() {
        if (this.item() == null) {
            return;
        }
        System system = (System)((Object)this.item().object());
        SystemLoadMetrics metrics = this.initProjectMetrics(system);
        if (metrics != null) {
            ((SystemLoadNotifier)this.notifier).render(this.addMaximums(metrics));
        }
    }

    public void refresh() {
        super.refresh();
        this.reload();
    }

    public void reload() {
        if (this.item() == null) {
            return;
        }
        SystemLoadMetrics value = this.addMaximums(this.lastProjectMetrics((System)((Object)this.item().object())));
        ((SystemLoadNotifier)this.notifier).update(value);
    }

    private SystemLoadMetrics addMaximums(SystemLoadMetrics metrics) {
        metrics.maxCpu(100);
        metrics.maxMemory((int)(metrics.memory().stream().max(Double::compareTo).orElse(100.0) * 1.1));
        return metrics.maxThreads(metrics.threads().stream().max(Integer::compareTo).orElse(95) + 5);
    }

    private SystemLoadMetrics lastProjectMetrics(System system) {
        List<SystemStatus> records = this.statusTimeRangeOf(system, this.lastFifteenMinutes());
        return records.isEmpty() ? new SystemLoadMetrics() : this.fillMetricsWith(records.get(0).created(), records);
    }

    private TimeRange lastFifteenMinutes() {
        return new TimeRange(Instant.now().minus(15L, ChronoUnit.MINUTES), Instant.now(), TimeScale.FifteenMinutes);
    }

    private SystemLoadMetrics initProjectMetrics(System system) {
        List<SystemStatus> records = this.statusTimeRangeOf(system, this.lastSixHours());
        return records.isEmpty() ? null : this.fillMetricsWith(records.get(0).created(), records);
    }

    private TimeRange lastSixHours() {
        return new TimeRange(Instant.now().minus(6L, ChronoUnit.HOURS), Instant.now(), TimeScale.FifteenMinutes);
    }

    private SystemLoadMetrics fillMetricsWith(Instant from, List<SystemStatus> records) {
        return new SystemLoadMetrics().from(from).cpu(records.stream().map(SystemStatus::cpuUsage).collect(Collectors.toList())).memory(records.stream().map(SystemStatus::memoryUsage).collect(Collectors.toList())).threads(records.stream().map(SystemStatus::threads).collect(Collectors.toList()));
    }

    private List<SystemStatus> statusTimeRangeOf(System system, TimeRange range) {
        return QueryExecutor.execute((Query)this.queryOf(system, range)).values().stream().map(tr -> (SystemStatus)tr.a$(SystemStatus.class)).collect(Collectors.toList());
    }

    private Query queryOf(System system, TimeRange range) {
        return new Query(system.graph().default$(), this.conceptOf(system.graph().core$()), range).filter(Collections.singletonList(system.core$().id()));
    }

    private Concept conceptOf(Graph graph) {
        return graph.concept(SystemStatus.class);
    }
}

