/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractSystemIssueMold;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemStatus;
import io.intino.cesar.graph.rules.Issue;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.time.Instant;

public class SystemIssueMold
extends AbstractSystemIssueMold {
    public SystemIssueMold(CesarBox box) {
        super(box);
    }

    public static class Stamps {
        public static String cpuIcon(Identifiable target, Instant ts) {
            return ((System)target.a$(System.class)).status(ts) == null || ((System)target.a$(System.class)).isStopped() ? null : "icons:work";
        }

        static String memoryIcon(Identifiable target, Instant ts) {
            if (!((System)target.a$(System.class)).isRunningOutOfMemory(ts)) {
                return "";
            }
            SystemStatus status = ((System)target.a$(System.class)).status(ts);
            return status == null || ((System)target.a$(System.class)).isStopped() ? null : "hardware:memory";
        }

        static String stoppedIcon(Identifiable target) {
            return ((System)target.a$(System.class)).isStopped() ? "warning" : null;
        }

        public static String cpuIconStyle(Identifiable target, Instant ts) {
            System system = (System)target.a$(System.class);
            SystemStatus status = system.status(ts);
            if (status == null) {
                return "";
            }
            return status.cpuUsage() > 90.0 ? "color:green;" : "color:red;";
        }

        public static String cpuTitle(Identifiable target, Instant ts) {
            System system = (System)target.a$(System.class);
            if (system.status(ts) == null) {
                return "";
            }
            return String.valueOf(system.status(ts).cpuUsage()) + " %";
        }

        static String memoryIconStyle(Identifiable target, Instant ts) {
            System system = (System)target.a$(System.class);
            SystemStatus status = system.status(ts);
            if (status == null) {
                return "";
            }
            return status.memoryUsage() > 90.0 ? "color:green;" : "color:red;";
        }

        static String memoryTitle(Identifiable target, Instant ts) {
            System system = (System)target.a$(System.class);
            SystemStatus status = system.status(ts);
            if (status == null) {
                return "";
            }
            return String.valueOf(status.memoryUsage()) + " %";
        }

        static String threadsTitle(Identifiable target, Instant ts) {
            SystemStatus status = ((System)target.a$(System.class)).status(ts);
            return status == null ? "" : String.valueOf(status.threads()) + " threads";
        }

        static String timeTitle(Instant ts) {
            return String.format("date(%s,LLL)", ts.toEpochMilli());
        }

        public static class SystemIssueDescription {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().shortMessage(issueReport.target());
            }
        }

        public static class Name {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.target().label();
            }
        }

        public static class TimeIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.Disconnected) ? "device:access-time" : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.timeTitle(issueReport.ts());
            }
        }

        public static class Threads {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Threads.threadsIcon(issueReport.target(), issueReport.ts());
            }

            private static String threadsIcon(Identifiable target, Instant ts) {
                return ((System)target.a$(System.class)).status(ts) == null || !((System)target.a$(System.class)).isRunningOutOfMemory(ts) ? "" : "device:usb";
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:green;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.threadsTitle(issueReport.target(), issueReport.ts());
            }
        }

        public static class Memory {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.memoryIcon(issueReport.target(), issueReport.ts());
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.memoryIconStyle(issueReport.target(), issueReport.ts());
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.memoryTitle(issueReport.target(), issueReport.ts());
            }
        }

        public static class CpuIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return !((System)issueReport.target().a$(System.class)).isRunningOutOfCpu(issueReport.ts()) ? "" : Stamps.cpuIcon(issueReport.target(), issueReport.ts());
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.cpuIconStyle(issueReport.target(), issueReport.ts());
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Stamps.cpuTitle(issueReport.target(), issueReport.ts());
            }
        }

        public static class Stopped {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.Stopped) ? Stamps.stoppedIcon(issueReport.target()) : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "Stopped";
            }
        }
    }
}

