/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.commanders.SystemCommander;
import io.intino.cesar.box.displays.AbstractSystemInfoMold;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.graph.AbstractSystem;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.consul.schemas.SystemStatus;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.TaskOperation;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.ness.inl.Message;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class SystemInfoMold
extends AbstractSystemInfoMold {
    public SystemInfoMold(CesarBox box) {
        super(box);
    }

    public static class Blocks {

        public static class DebugBlock {
            public static boolean hidden(System system) {
                return !system.debugging();
            }
        }
    }

    public static class Stamps {

        public static class Refresh {
            public static TaskOperation.Refresh execute(CesarBox box, System system, String selfId, ActivitySession session) {
                SystemStatus status = Query.SystemHelper.commander(box.datalake(), system).status();
                if (status != null) {
                    NessTanks.systemStatus().feed(Message.load((String)MessageManager.toInl(status)));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return TaskOperation.Refresh.Item;
            }

            public static String drawingColor(CesarBox box, System object, ActivitySession session) {
                return null;
            }
        }

        public static class Logo {
            public static List<URL> value(CesarBox box, System system, ActivitySession session) {
                return Collections.singletonList(system.logo());
            }
        }

        public static class SystemVersion {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.artifact().version();
            }
        }

        public static class Update {
            public static TaskOperation.Refresh execute(CesarBox box, System system, String selfId, ActivitySession session) {
                return TaskOperation.Refresh.None;
            }

            public static String drawingColor(CesarBox box, System object, ActivitySession session) {
                return null;
            }
        }

        public static class Start {
            public static TaskOperation.Refresh execute(CesarBox box, System system, String selfId, ActivitySession session) {
                if (!system.started()) {
                    new SystemCommander(box.datalake(), system).restart();
                }
                return Refresh.execute(box, system, selfId, session);
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                return !system.isStopped() ? "display:none" : "display:block";
            }

            public static String drawingColor(CesarBox box, System object, ActivitySession session) {
                return null;
            }
        }

        public static class Restart {
            public static TaskOperation.Refresh execute(CesarBox box, System system, String selfId, ActivitySession session) {
                new SystemCommander(box.datalake(), system).restart();
                return Refresh.execute(box, system, selfId, session);
            }

            public static String drawingColor(CesarBox box, System object, ActivitySession session) {
                return null;
            }
        }

        public static class Stop {
            public static TaskOperation.Refresh execute(CesarBox box, System system, String selfId, ActivitySession session) {
                new SystemCommander(box.datalake(), system).stop();
                return Refresh.execute(box, system, selfId, session);
            }

            public static String style(CesarBox box, System system, ActivitySession session) {
                return system.isStopped() ? "display:none" : "display:block";
            }

            public static String drawingColor(CesarBox box, System object, ActivitySession session) {
                return "redindian";
            }
        }

        public static class Debug {
            public static TaskOperation.Refresh execute(CesarBox box, System system, String selfId, ActivitySession session) {
                new SystemCommander(box.datalake(), system).debug();
                return TaskOperation.Refresh.Item;
            }

            public static String drawingColor(CesarBox box, System object, ActivitySession session) {
                return null;
            }
        }

        public static class ArtifactId {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.artifact().artifactId();
            }
        }

        public static class Group {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.artifact().group();
            }
        }

        public static class V {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return "v. ";
            }
        }

        public static class Container {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return "container";
            }
        }

        public static class ContainerName {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return ((Server)system.consul().core$().ownerAs(Server.class)).core$().name();
            }

            public static String item(CesarBox box, System system, ActivitySession session) {
                return ((Server)system.consul().core$().ownerAs(Server.class)).core$().id();
            }
        }

        public static class JvmParameters {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return "jmv parameters";
            }
        }

        public static class JmxPort {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.operations().port() + "";
            }
        }

        public static class JmxPortLabel {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return "jmx port";
            }
        }

        public static class Memory {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return "memory";
            }
        }

        public static class MemoryValue {
            public static String value(CesarBox box, System system, ActivitySession session) {
                AbstractSystem.Deployment deployment = system.currentDeployment();
                if (deployment == null) {
                    return "";
                }
                if (deployment.prerequisites() == null) {
                    deployment.create().prerequisites();
                }
                return deployment.prerequisites().memory() + " mb";
            }
        }

        public static class DebugPort {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return system.debugPort() + "";
            }
        }

        public static class DebugLabel {
            public static String value(CesarBox box, System system, ActivitySession session) {
                return "debug";
            }
        }
    }
}

