/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractServerIssueMold;
import io.intino.cesar.box.displays.SystemIssueMold;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.FeederStatus;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerStatus;
import io.intino.cesar.graph.rules.Issue;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.time.Instant;

public class ServerIssueMold
extends AbstractServerIssueMold {
    public ServerIssueMold(CesarBox box) {
        super(box);
    }

    public static class Stamps {

        public static class ServerIssueDescription {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Feeder feeder = (Feeder)issueReport.target().a$(Feeder.class);
                FeederStatus status = feeder.status(issueReport.ts());
                if (status == null) {
                    return "no data";
                }
                StringBuilder builder = new StringBuilder();
                builder.append(" since ").append(String.format("date(%s,LLL)", status.created().toEpochMilli()));
                if (feeder.isDisconnected()) {
                    return builder.append(" is disconnected").toString();
                }
                if (feeder.isHot()) {
                    builder.append(" has ").append(status.temperature()).append("\u00b0,");
                }
                if (feeder.isRunningOutOfMemory()) {
                    builder.append("is running out memory,");
                }
                if (feeder.isRunningOutOfCpu()) {
                    builder.append("is running out cpu,");
                }
                if (feeder.isRunningOutOfDisk()) {
                    builder.append("is running out disk,");
                }
                String value = builder.toString();
                return value.substring(0, value.length() - 1) + ".";
            }
        }

        public static class Name {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.target().label();
            }
        }

        public static class TimeIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.Disconnected) ? "device:access-time" : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return SystemIssueMold.Stamps.timeTitle(issueReport.ts());
            }
        }

        public static class HddIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return ((Server)issueReport.target().a$(Server.class)).isRunningOutOfDisk(issueReport.ts()) ? "notification:disc-full" : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return ((Server)issueReport.target().a$(Server.class)).isRunningOutOfDisk(issueReport.ts()) ? "color:red;" : "color:green;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                ServerStatus status = ((Server)issueReport.target().a$(Server.class)).status(issueReport.ts());
                return status == null ? null : status.diskUsage() + " %";
            }
        }

        public static class CpuIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Identifiable target = issueReport.target();
                ServerStatus status = ((Server)target.a$(Server.class)).status(issueReport.ts());
                return status == null ? "" : "icons:work";
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Server target = (Server)issueReport.target().a$(Server.class);
                ServerStatus status = target.status(issueReport.ts());
                return status == null ? "" : (target.isRunningOutOfCpu(issueReport.ts()) ? "color:red;" : "color:green;");
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                ServerStatus status = ((Server)issueReport.target().a$(Server.class)).status(issueReport.ts());
                return status == null ? null : status.cpuUsage() + " %";
            }
        }

        public static class HotIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Identifiable target = issueReport.target();
                return !target.i$(Feeder.class) || ((Feeder)target.a$(Feeder.class)).status(issueReport.ts()) == null ? null : "social:whatshot";
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Identifiable target = issueReport.target();
                Instant ts = issueReport.ts();
                if (!target.i$(Feeder.class)) {
                    return "";
                }
                Feeder feeder = (Feeder)target.a$(Feeder.class);
                FeederStatus status = feeder.status(ts);
                if (status == null) {
                    return "";
                }
                return !feeder.isHot(ts) ? "color:blue;" : "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Feeder feeder = (Feeder)issueReport.target().a$(Feeder.class);
                FeederStatus status = feeder.status(issueReport.ts());
                if (status == null) {
                    return "";
                }
                return String.valueOf(status.temperature()) + " \u00ba";
            }
        }

        public static class NoData {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.Disconnected) ? "warning" : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "Disconnected";
            }
        }
    }
}

