/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.Utils;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractProjectDashboard;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Feeder;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.IssueTracker;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;

public class ProjectDashboard
extends AbstractProjectDashboard {
    public ProjectDashboard(CesarBox box) {
        super(box);
    }

    public static class Blocks {

        public static class ServerIssuesLink {
            public static boolean hidden(Project project) {
                long count = project.graph().issueTracker().issueReportList().stream().filter(i -> i.target() != null && i.target().i$(Server.class) && !i.target().i$(Feeder.class) && project.servers().contains(i.target().core$().as(Server.class)) && i.status().equals((Object)IssueReport.Status.Open)).count();
                return count < 5L;
            }
        }

        public static class FeederIssuesLink {
            public static boolean hidden(Project project) {
                long count = project.graph().issueTracker().issueReportList().stream().filter(i -> i.target() != null && i.target().i$(Feeder.class) && project.feeders().contains(i.target().core$().as(Feeder.class)) && i.status().equals((Object)IssueReport.Status.Open)).count();
                return count < 5L;
            }
        }

        public static class DeviceIssuesLink {
            public static boolean hidden(Project project) {
                long count = project.graph().issueTracker().issueReportList().stream().filter(i -> i.target() != null && i.target().i$(Device.class) && project.devices().contains(i.target().core$().as(Device.class)) && i.status().equals((Object)IssueReport.Status.Open)).count();
                return count < 5L;
            }
        }

        public static class SystemIssuesLink {
            public static boolean hidden(Project project) {
                long count = project.graph().issueTracker().issueReportList().stream().filter(i -> i.target() != null && i.target().i$(System.class) && project.systemList().contains(i.target().core$().as(System.class)) && i.status().equals((Object)IssueReport.Status.Open)).count();
                return count < 5L;
            }
        }

        public static class History {
            public static boolean hidden(Project project) {
                return project.graph().issueTracker().historic().stream().noneMatch(i -> i.target() != null && History.isInProject(i.target(), project));
            }

            private static boolean isInProject(Identifiable i, Project project) {
                if (i.i$(Asset.class)) {
                    return project.assets().contains(i.a$(Asset.class));
                }
                return ((Object)((Object)((Project)((System)i.a$(System.class)).core$().ownerAs(Project.class)))).equals((Object)project);
            }
        }

        public static class Servers {
            public static boolean hidden(Project project) {
                return project.servers().isEmpty();
            }
        }

        public static class Feeders {
            public static boolean hidden(Project project) {
                return project.feeders().isEmpty();
            }
        }

        public static class Devices {
            public static boolean hidden(Project project) {
                return project.devices().isEmpty();
            }
        }

        public static class Systems {
            public static boolean hidden(Project project) {
                return project.systemList().isEmpty();
            }
        }
    }

    public static class Stamps {
        private static String showQuality(int issues, int elements) {
            String quality = Utils.letterScoreByIssues(elements == 0 ? 0.0 : (double)(issues / elements * 100));
            String background = "background:" + Utils.colourScoreByIssues(elements == 0 ? 0.0 : (double)(issues / elements * 100)) + ";";
            return Stamps.qualityHtml(quality, background);
        }

        private static int systemIssues(Project project) {
            IssueTracker issueTracker = project.graph().issueTracker();
            if (issueTracker == null) {
                return 0;
            }
            return (int)issueTracker.issueReportList().stream().filter(i -> i.target().i$(System.class) && ((Object)((Object)project)).equals(i.target().core$().ownerAs(Project.class)) && i.status().equals((Object)IssueReport.Status.Open)).count();
        }

        static int assetIssues(Project project, Class tClass) {
            IssueTracker issueTracker = project.graph().issueTracker();
            if (issueTracker == null) {
                return 0;
            }
            return (int)issueTracker.issueReportList().stream().filter(i -> i.target().i$(tClass) && project.assets().contains((Object)i.target()) && i.status().equals((Object)IssueReport.Status.Open)).count();
        }

        static int assetIssues(Project project, Class tClass, Class not) {
            IssueTracker issueTracker = project.graph().issueTracker();
            if (issueTracker == null) {
                return 0;
            }
            return (int)issueTracker.issueReportList().stream().filter(i -> i.target().i$(tClass) && !i.target().i$(not) && project.assets().contains((Object)i.target()) && i.status().equals((Object)IssueReport.Status.Open)).count();
        }

        private static String issueCountHtml(int issues) {
            return "<div style='height: 100px; width: 100px;margin-left: 50px;margin-right: 25px;margin-bottom: 10px;'><div style='text-align:center;font-size:48pt;'>" + issues + "</div><h3 style='text-align:center;margin-top:2px;color:#707070;font-size:10pt;'>Issues</h3></div>";
        }

        private static String qualityHtml(String quality, String background) {
            return "<div style='height: 100px; width: 100px;margin-left: 25px;margin-right: 50px;margin-bottom: 10px;'><div style='text-align:center;font-size:48pt;margin:0px 20px 0px 20px;color:white;" + background + "'>" + quality + "</div><h3 style='text-align:center;margin-top:2px;color:#707070;font-size:10pt;'>Quality</h3></div>";
        }

        public static class EmbeddedHistoryCatalog {
            public static boolean filter(CesarBox box, Element element, Project source, Object target, ActivitySession session) {
                return ((IssueReport)((Object)target)).status().equals((Object)IssueReport.Status.Closed) && source.idenfitiables().contains((Object)((IssueReport)((Object)target)).target());
            }
        }

        public static class History {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return "History";
            }
        }

        public static class ServerStampCatalog {
            public static boolean filter(CesarBox box, Element element, Project source, Object target, ActivitySession session) {
                IssueReport report = (IssueReport)((Object)target);
                return report.target().i$(Server.class) && source.servers().contains(report.target().a$(Server.class));
            }
        }

        public static class ServerQuality {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                int issues = Stamps.assetIssues(project, Server.class);
                return Stamps.showQuality(issues, project.devices().size());
            }
        }

        public static class ServerIssues {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return Stamps.issueCountHtml(Stamps.assetIssues(project, Server.class, Feeder.class));
            }
        }

        public static class Servers {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return "Servers";
            }
        }

        public static class FeedersStampCatalog {
            public static boolean filter(CesarBox box, Element element, Project source, Object target, ActivitySession session) {
                IssueReport report = (IssueReport)((Object)target);
                return report.target().i$(Feeder.class) && source.feeders().contains(report.target().a$(Feeder.class));
            }
        }

        public static class FeederQuality {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                int issues = Stamps.assetIssues(project, Device.class);
                return Stamps.showQuality(issues, project.devices().size());
            }
        }

        public static class FeederIssues {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return Stamps.issueCountHtml(Stamps.assetIssues(project, Feeder.class));
            }
        }

        public static class Feeders {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return "Feeders";
            }
        }

        public static class DevicesStampCatalog {
            public static boolean filter(CesarBox box, Element element, Project source, Object target, ActivitySession session) {
                IssueReport report = (IssueReport)((Object)target);
                return report.target().i$(Device.class) && source.devices().contains(report.target().a$(Device.class));
            }
        }

        public static class DeviceQuality {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return Stamps.showQuality(Stamps.assetIssues(project, Device.class), project.devices().size());
            }
        }

        public static class DeviceIssues {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return Stamps.issueCountHtml(Stamps.assetIssues(project, Device.class));
            }
        }

        public static class Devices {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return "Devices";
            }
        }

        public static class SystemsIssuesCatalog {
            public static boolean filter(CesarBox box, Element element, Project source, Object target, ActivitySession session) {
                IssueReport report = (IssueReport)((Object)target);
                return report.target().i$(System.class) && source.systemList().contains(report.target().a$(System.class));
            }
        }

        public static class SystemQuality {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                int issues = Stamps.systemIssues(project);
                return Stamps.showQuality(issues, project.systemList().size());
            }
        }

        public static class Systems {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return "Systems";
            }
        }

        public static class SystemIssues {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return Stamps.issueCountHtml(Stamps.systemIssues(project));
            }
        }

        public static class ShowMore {
            public static String value(CesarBox box, Project project, ActivitySession session) {
                return "show more";
            }
        }
    }
}

