/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AdminPanel;
import io.intino.cesar.box.displays.AdministrationMold;
import io.intino.cesar.box.displays.AssetCatalog;
import io.intino.cesar.box.displays.CesarDesktop;
import io.intino.cesar.box.displays.CesarDevicePanel;
import io.intino.cesar.box.displays.CesarSystemPanel;
import io.intino.cesar.box.displays.DeviceCatalog;
import io.intino.cesar.box.displays.DeviceInfoMold;
import io.intino.cesar.box.displays.DeviceIssueMold;
import io.intino.cesar.box.displays.DeviceIssuesCatalog;
import io.intino.cesar.box.displays.DeviceMold;
import io.intino.cesar.box.displays.DeviceOperationsMold;
import io.intino.cesar.box.displays.DevicePreviewGridMold;
import io.intino.cesar.box.displays.DevicePreviewMold;
import io.intino.cesar.box.displays.DeviceRulesMold;
import io.intino.cesar.box.displays.FeederCatalog;
import io.intino.cesar.box.displays.FeederIssuesCatalog;
import io.intino.cesar.box.displays.FeederPreviewMold;
import io.intino.cesar.box.displays.HistoryCatalog;
import io.intino.cesar.box.displays.IssueMold;
import io.intino.cesar.box.displays.MainMenu;
import io.intino.cesar.box.displays.OverviewMold;
import io.intino.cesar.box.displays.OverviewPanel;
import io.intino.cesar.box.displays.ParameterMold;
import io.intino.cesar.box.displays.ProjectDashboard;
import io.intino.cesar.box.displays.ProjectPanel;
import io.intino.cesar.box.displays.ResponsibleMold;
import io.intino.cesar.box.displays.ResponsiblesCatalog;
import io.intino.cesar.box.displays.ServerCatalog;
import io.intino.cesar.box.displays.ServerIssueMold;
import io.intino.cesar.box.displays.ServerIssuesCatalog;
import io.intino.cesar.box.displays.ServerPreviewMold;
import io.intino.cesar.box.displays.SystemCatalog;
import io.intino.cesar.box.displays.SystemInfoMold;
import io.intino.cesar.box.displays.SystemIssueMold;
import io.intino.cesar.box.displays.SystemIssuesCatalog;
import io.intino.cesar.box.displays.SystemMold;
import io.intino.cesar.box.displays.SystemOperationMold;
import io.intino.cesar.box.displays.SystemOperationsCatalog;
import io.intino.cesar.box.displays.SystemOperationsMold;
import io.intino.cesar.box.displays.SystemParametersCatalog;
import io.intino.cesar.box.displays.SystemPreviewMold;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.ActivityBox;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDesktop;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaMenuLayout;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanel;
import io.intino.konos.alexandria.activity.displays.AlexandriaTabLayout;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalRangeCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalTimeCatalog;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Desktop;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Layout;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.TemporalCatalog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Displays {
    private static Map<String, ElementDisplayBuilder> displayMap = new HashMap<String, ElementDisplayBuilder>();

    public static AlexandriaElementDisplay displayFor(CesarBox box, String name) {
        if (!displayMap.containsKey(name)) {
            return null;
        }
        return displayMap.get(name).build(box);
    }

    public static AlexandriaElementDisplay displayFor(CesarBox box, Element element) {
        if (!displayMap.containsKey(element.name())) {
            return Displays.defaultElement(box, element);
        }
        return displayMap.get(element.name()).build(box);
    }

    public static <T extends Element> List<T> elementsFor(CesarBox box, Class<T> tClass, String ... elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (String element : elements) {
            list.add(displayMap.get(element).build(box).element());
        }
        return list;
    }

    public static Class<? extends AlexandriaElementDisplay> displayTypeFor(CesarBox box, Element element) {
        if (!displayMap.containsKey(element.name())) {
            return Displays.defaultElementType(box, element);
        }
        return displayMap.get(element.name()).build(box).getClass();
    }

    private static Class<? extends AlexandriaElementDisplay> defaultElementType(CesarBox box, Element element) {
        if (element instanceof Panel) {
            return AlexandriaPanel.class;
        }
        if (element instanceof TemporalCatalog) {
            return ((TemporalCatalog)element).type() == TemporalCatalog.Type.Range ? AlexandriaTemporalRangeCatalog.class : AlexandriaTemporalTimeCatalog.class;
        }
        if (element instanceof Catalog) {
            return AlexandriaCatalog.class;
        }
        if (element instanceof Layout) {
            return ((Layout)element).mode() == Layout.Mode.Menu ? AlexandriaMenuLayout.class : AlexandriaTabLayout.class;
        }
        if (element instanceof Desktop) {
            return AlexandriaDesktop.class;
        }
        return null;
    }

    private static AlexandriaElementDisplay defaultElement(CesarBox box, Element element) {
        if (element instanceof Panel) {
            return new AlexandriaPanel((Box)box);
        }
        if (element instanceof TemporalCatalog) {
            return ((TemporalCatalog)element).type() == TemporalCatalog.Type.Range ? new AlexandriaTemporalRangeCatalog((Box)box) : new AlexandriaTemporalTimeCatalog((Box)box);
        }
        if (element instanceof Catalog) {
            return new AlexandriaCatalog((Box)box);
        }
        if (element instanceof Layout) {
            return ((Layout)element).mode() == Layout.Mode.Menu ? new AlexandriaMenuLayout((Box)box) : new AlexandriaTabLayout((Box)box);
        }
        if (element instanceof Desktop) {
            return new AlexandriaDesktop((ActivityBox)box);
        }
        return null;
    }

    static {
        displayMap.put("cesarDevicePanel", box -> new CesarDevicePanel(box));
        displayMap.put("deviceInfoMold", box -> new DeviceInfoMold(box));
        displayMap.put("deviceMold", box -> new DeviceMold(box));
        displayMap.put("deviceRulesMold", box -> new DeviceRulesMold(box));
        displayMap.put("deviceOperationsMold", box -> new DeviceOperationsMold(box));
        displayMap.put("projectDashboard", box -> new ProjectDashboard(box));
        displayMap.put("deviceIssuesCatalog", box -> new DeviceIssuesCatalog(box));
        displayMap.put("serverIssuesCatalog", box -> new ServerIssuesCatalog(box));
        displayMap.put("systemIssuesCatalog", box -> new SystemIssuesCatalog(box));
        displayMap.put("feederIssuesCatalog", box -> new FeederIssuesCatalog(box));
        displayMap.put("historyCatalog", box -> new HistoryCatalog(box));
        displayMap.put("issueMold", box -> new IssueMold(box));
        displayMap.put("systemIssueMold", box -> new SystemIssueMold(box));
        displayMap.put("serverIssueMold", box -> new ServerIssueMold(box));
        displayMap.put("deviceIssueMold", box -> new DeviceIssueMold(box));
        displayMap.put("overviewMold", box -> new OverviewMold(box));
        displayMap.put("feederPreviewMold", box -> new FeederPreviewMold(box));
        displayMap.put("serverPreviewMold", box -> new ServerPreviewMold(box));
        displayMap.put("systemPreviewMold", box -> new SystemPreviewMold(box));
        displayMap.put("devicePreviewGridMold", box -> new DevicePreviewGridMold(box));
        displayMap.put("devicePreviewMold", box -> new DevicePreviewMold(box));
        displayMap.put("administrationMold", box -> new AdministrationMold(box));
        displayMap.put("responsibleMold", box -> new ResponsibleMold(box));
        displayMap.put("cesarDesktop", box -> new CesarDesktop(box));
        displayMap.put("mainMenu", box -> new MainMenu(box));
        displayMap.put("overviewPanel", box -> new OverviewPanel(box));
        displayMap.put("adminPanel", box -> new AdminPanel(box));
        displayMap.put("projectPanel", box -> new ProjectPanel(box));
        displayMap.put("responsiblesCatalog", box -> new ResponsiblesCatalog(box));
        displayMap.put("deviceCatalog", box -> new DeviceCatalog(box));
        displayMap.put("serverCatalog", box -> new ServerCatalog(box));
        displayMap.put("feederCatalog", box -> new FeederCatalog(box));
        displayMap.put("systemCatalog", box -> new SystemCatalog(box));
        displayMap.put("assetCatalog", box -> new AssetCatalog(box));
        displayMap.put("systemOperationsCatalog", box -> new SystemOperationsCatalog(box));
        displayMap.put("cesarSystemPanel", box -> new CesarSystemPanel(box));
        displayMap.put("systemInfoMold", box -> new SystemInfoMold(box));
        displayMap.put("systemMold", box -> new SystemMold(box));
        displayMap.put("systemOperationsMold", box -> new SystemOperationsMold(box));
        displayMap.put("systemParametersCatalog", box -> new SystemParametersCatalog(box));
        displayMap.put("parameterMold", box -> new ParameterMold(box));
        displayMap.put("systemOperationMold", box -> new SystemOperationMold(box));
    }

    private static interface ElementDisplayBuilder {
        public AlexandriaElementDisplay build(CesarBox var1);
    }
}

