/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractDevicePreviewMold;
import io.intino.cesar.box.displays.Molds;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;

public class DevicePreviewMold
extends AbstractDevicePreviewMold {
    public DevicePreviewMold(CesarBox box) {
        super(box);
    }

    public static class Stamps {

        public static class StatusDescription {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                if (!device.isCompromised()) {
                    return "Last status was at " + String.format("date(%s,LLL)", device.status().created().toEpochMilli());
                }
                if (device.status() == null) {
                    return "no data";
                }
                StringBuilder builder = new StringBuilder();
                builder.append(" since ").append(String.format("date(%s,LLL)", device.status().created().toEpochMilli())).append(" ");
                if (device.isDisconnected()) {
                    return builder.append(" is disconnected").toString();
                }
                if (device.isHot()) {
                    builder.append(" has ").append(device.status().temperature()).append("\u00b0,");
                }
                if (device.isUnPlugged()) {
                    builder.append(" is unplugged,");
                }
                if (device.lowBattery() || device.veryLowBattery()) {
                    builder.append(" is discharging battery (").append(device.status().battery()).append("%),");
                }
                if (!device.isScreenOn()) {
                    builder.append(" has screen off,");
                }
                String value = builder.toString();
                return value.substring(0, value.length() - 1) + ".";
            }
        }

        public static class TimeIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() != null && device.isDisconnected() ? "device:access-time" : null;
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return !device.isDisconnected() ? "color:green;" : "color:red;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return null;
                }
                return String.format("date(%s,LLL)", ((Device)device.a$(Device.class)).status().created().toEpochMilli());
            }
        }

        public static class HotIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null || !device.isHot() ? null : "social:whatshot";
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return !device.isHot() ? "color:blue;" : "color:red;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return String.valueOf(device.status().temperature()) + " \u00ba";
            }
        }

        public static class BatteryIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                DeviceStatus status = device.status();
                if (status == null || device.isDisconnected() || !device.isUnPlugged() && !device.lowBattery()) {
                    return null;
                }
                String prefix = "device:battery-" + (status.isPlugged() ? "charging-" : "");
                if (status.battery() == 100.0) {
                    return prefix + "full";
                }
                return prefix + BatteryIcon.nearestLevel(status.battery());
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                if (!device.lowBattery()) {
                    return "color:orange;";
                }
                if (!device.veryLowBattery()) {
                    return "color:red;";
                }
                return "color:green;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? "" : String.valueOf((int)device.status().battery()) + "%";
            }

            private static String nearestLevel(double battery) {
                int[] levels = new int[]{20, 30, 50, 60, 80, 90};
                int closest = 200;
                for (int level : levels) {
                    if (!(Math.abs(battery - (double)level) < (double)closest)) continue;
                    closest = level;
                }
                return String.valueOf(closest);
            }
        }

        public static class NoData {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return Molds.noDataIcon(device, null);
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return "";
            }
        }

        public static class Name {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.label();
            }
        }

        public static class UnpluggedIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                if (device.status() != null && !device.isDisconnected()) {
                    return device.isUnPlugged() ? "notification:power" : null;
                }
                return null;
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return !device.isUnPlugged() ? "color:green;" : "color:orange;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null || device.isDisconnected()) {
                    return "";
                }
                return device.isUnPlugged() ? "Unplugged" : "";
            }
        }

        public static class ScreenOff {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.isDisconnected() || device.isScreenOn() ? null : "hardware:tablet";
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return device.isScreenOn() ? "color:green;" : "color:orange;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? "" : "screen is off";
            }
        }
    }
}

