/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractDevicePreviewGridMold;
import io.intino.cesar.box.displays.Molds;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class DevicePreviewGridMold
extends AbstractDevicePreviewGridMold {
    public DevicePreviewGridMold(CesarBox box) {
        super(box);
    }

    public static class Stamps {

        public static class TimeIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() != null && device.isDisconnected() ? "device:access-time" : null;
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return !device.isDisconnected() ? "color:green;" : "color:red;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return null;
                }
                return String.format("date(%s,LLL)", ((Device)device.a$(Device.class)).status().created().toEpochMilli());
            }
        }

        public static class HotIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null || !device.isHot() ? null : "social:whatshot";
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return !device.isHot() ? "color:blue;" : "color:red;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                return String.valueOf(device.status().temperature()) + " \u00ba";
            }
        }

        public static class BatteryIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                DeviceStatus status = ((Device)device.a$(Device.class)).status();
                if (status == null) {
                    return null;
                }
                String prefix = "device:battery-" + (status.isPlugged() ? "charging-" : "");
                if (status.battery() == 100.0) {
                    return prefix + "full";
                }
                return prefix + BatteryIcon.nearestLevel(status.battery());
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                if (device.status() == null) {
                    return "";
                }
                if (!device.lowBattery()) {
                    return "color:green;";
                }
                if (!device.veryLowBattery()) {
                    return "color:orange;";
                }
                return "color:red;";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? "" : String.valueOf((int)device.status().battery()) + "%";
            }

            private static String nearestLevel(double battery) {
                int[] levels = new int[]{20, 30, 50, 60, 80, 90};
                int closest = 200;
                for (int level : levels) {
                    if (!(Math.abs(battery - (double)level) < (double)closest)) continue;
                    closest = level;
                }
                return String.valueOf(closest);
            }
        }

        public static class NoData {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return Molds.noDataIcon(device, null);
            }

            public static String style(CesarBox box, Device device, ActivitySession session) {
                return "";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return device.name$();
            }
        }

        public static class Name {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.label();
            }
        }

        public static class Image {
            public static List<URL> value(CesarBox box, Device device, ActivitySession session) {
                DeviceStatus status = device.status();
                if (status == null) {
                    return Collections.singletonList(DevicePreviewGridMold.class.getResource("/images/tablet_no_status.png"));
                }
                if (!status.isScreenOn()) {
                    return Collections.singletonList(DevicePreviewGridMold.class.getResource("/images/tablet_turnoff.png"));
                }
                return device.screen().current() != null ? Collections.singletonList(device.screen().current()) : null;
            }
        }
    }
}

