/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.displays.AbstractDeviceMold;
import io.intino.cesar.box.displays.DeviceIssuesTimeLine;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.ness.inl.Message;

public class DeviceMold
extends AbstractDeviceMold {
    public DeviceMold(CesarBox box) {
        super(box);
    }

    public static class Blocks {

        public static class TemperatureBlock {
            public static boolean hidden(Device device) {
                return device.isDisconnected();
            }
        }

        public static class BatteryBlock {
            public static boolean hidden(Device device) {
                return device.isDisconnected();
            }
        }

        public static class PowerBlock {
            public static boolean hidden(Device device) {
                return device.isDisconnected();
            }
        }

        public static class ScreenBlock {
            public static boolean hidden(Device device) {
                return device.isDisconnected();
            }
        }

        public static class ConnectionBlock {
            public static boolean hidden(Device device) {
                return !device.isDisconnected();
            }
        }
    }

    public static class Stamps {

        public static class Refresh {
            public static void execute(CesarBox box, Device device, ActivitySession session) {
                new Thread(() -> {
                    String response = Query.DeviceHelper.commander(box, device).status();
                    if (Query.DeviceHelper.valid(response)) {
                        Status status = MessageManager.fromInl(response, Status.class).get(0);
                        NessTanks.deviceStatus().feed(Message.load((String)MessageManager.toInl(status)));
                    }
                }).start();
            }
        }

        public static class DeviceTimeLine {
            public static AlexandriaStamp buildDisplay(CesarBox box, String name, ActivitySession session) {
                return new DeviceIssuesTimeLine(box);
            }
        }

        public static class On {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                if (device.isDisconnected()) {
                    String value = "Currently disconnected.";
                    return device.status() != null ? value + " Last status was on " + String.format("date(%s,LLL)", device.status().created().toEpochMilli()) : value;
                }
                return "On " + String.format("date(%s,LLL)", device.status().created().toEpochMilli());
            }
        }

        public static class ScreenStatus {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.isDisconnected() ? "off" : (device.status().isScreenOn() ? "on" : "off");
            }
        }

        public static class ScreenDescription {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "screen";
            }
        }

        public static class ScreenIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "hardware:tablet";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return "Screen";
            }
        }

        public static class PowerStatus {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? null : (device.status().isPlugged() ? "plugged" : "unplugged");
            }
        }

        public static class PowerIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "notification:power";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return "power";
            }
        }

        public static class PowerDescription {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "power";
            }
        }

        public static class BatteryIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return BatteryIcon.batteryIcon(device);
            }

            static String batteryIcon(Device device) {
                DeviceStatus status = device.status();
                return BatteryIcon.batteryIcon(status);
            }

            static String batteryIcon(DeviceStatus status) {
                if (status == null) {
                    return "";
                }
                String prefix = "device:battery-" + (status.isPlugged() ? "charging-" : "");
                if (status.battery() == 100.0) {
                    return prefix + "full";
                }
                return prefix + BatteryIcon.nearestLevel(status.battery());
            }

            private static String nearestLevel(double battery) {
                int[] levels = new int[]{20, 30, 50, 60, 80, 90};
                int closest = 200;
                for (int level : levels) {
                    if (!(Math.abs(battery - (double)level) < (double)closest)) continue;
                    closest = level;
                }
                return String.valueOf(closest);
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? null : device.status().battery() + "%";
            }
        }

        public static class BatteryDescription {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "battery";
            }
        }

        public static class BatteryStatus {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? null : String.format("%.2f", device.status().battery()) + "%";
            }
        }

        public static class TemperatureStatus {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? null : String.format("%.2f", device.status().temperature()) + "\u00b0";
            }
        }

        public static class TemperatureIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "social:whatshot";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return device.status() == null ? null : device.status().temperature() + "\u00b0";
            }
        }

        public static class TemperatureDescription {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "temperature";
            }
        }

        public static class ConnectionStatus {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.isDisconnected() ? "disconnected" : "connected";
            }
        }

        public static class ConnectionIcon {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "device:signal-cellular-connected-no-internet-0-bar";
            }

            public static String title(CesarBox box, Device device, ActivitySession session) {
                return "connection";
            }
        }

        public static class ConnectionDescription {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "connection";
            }
        }

        public static class Timeline {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "timeline";
            }
        }
    }
}

