/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.DeviceMold;
import io.intino.cesar.box.displays.notifiers.DeviceIssuesTimeLineNotifier;
import io.intino.cesar.box.schemas.DeviceTimelineEvent;
import io.intino.cesar.box.schemas.TimeRange;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.sumus.queries.temporalrecord.Query;
import io.intino.sumus.queries.temporalrecord.QueryExecutor;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceIssuesTimeLine
extends AlexandriaStamp<DeviceIssuesTimeLineNotifier> {
    private CesarBox box;

    public DeviceIssuesTimeLine(CesarBox box) {
        this.box = box;
    }

    protected void init() {
        List<DeviceTimelineEvent> events = this.load(Instant.now().minus(7L, ChronoUnit.DAYS), Instant.now());
        if (events != null) {
            ((DeviceIssuesTimeLineNotifier)this.notifier).render(events);
        }
    }

    public void reload(TimeRange timeRange) {
        if (this.item() == null) {
            return;
        }
        ((DeviceIssuesTimeLineNotifier)this.notifier).update(this.load(timeRange.from(), timeRange.to()));
    }

    private List<DeviceTimelineEvent> load(Instant from, Instant to) {
        Device device = (Device)((Object)this.item().object());
        Query query = new Query(this.box.graph().default$(), this.box.graph().core$().concept(DeviceStatus.class), new io.intino.konos.alexandria.activity.model.TimeRange(from, to, TimeScale.FifteenMinutes));
        List<DeviceStatus> status = QueryExecutor.execute((Query)query.filter(this.byDevice(device))).values().stream().map(t -> (DeviceStatus)t.a$(DeviceStatus.class)).collect(Collectors.toList());
        return this.transform(status);
    }

    private List<DeviceTimelineEvent> transform(List<DeviceStatus> statuses) {
        ArrayList<DeviceTimelineEvent> timeLine = new ArrayList<DeviceTimelineEvent>();
        DeviceTimelineEvent unplugged = null;
        DeviceTimelineEvent screenOff = null;
        DeviceTimelineEvent lowBattery = null;
        DeviceTimelineEvent veryLowBattery = null;
        DeviceStatus lastStatus = null;
        for (DeviceStatus status : statuses) {
            boolean disconnected = this.addDisconnected(timeLine, lastStatus, status);
            unplugged = this.unplug(timeLine, unplugged, lastStatus, status, disconnected);
            screenOff = this.screen(timeLine, screenOff, lastStatus, status, disconnected);
            if ((veryLowBattery = this.veryLowBattery(timeLine, veryLowBattery, lastStatus, status, disconnected)) == null || !status.created().equals(veryLowBattery.start()) && !status.created().equals(veryLowBattery.end())) {
                lowBattery = this.lowBattery(timeLine, lowBattery, lastStatus, status, disconnected);
            }
            this.addTemperature(timeLine, status);
            lastStatus = status;
        }
        return timeLine;
    }

    private DeviceTimelineEvent unplug(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent unplugged, DeviceStatus lastStatus, DeviceStatus status, boolean disconnected) {
        if (unplugged != null && disconnected) {
            unplugged.end(lastStatus.created());
            return null;
        }
        return this.addUnplugs(timeLine, unplugged, status);
    }

    private DeviceTimelineEvent screen(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent screenOff, DeviceStatus lastStatus, DeviceStatus status, boolean disconnected) {
        if (screenOff != null && disconnected) {
            screenOff.end(lastStatus.created());
            return null;
        }
        return this.addScreenOff(timeLine, screenOff, status);
    }

    private DeviceTimelineEvent veryLowBattery(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent veryLowBattery, DeviceStatus lastStatus, DeviceStatus status, boolean disconnected) {
        if (disconnected && veryLowBattery != null) {
            veryLowBattery.end(lastStatus.created());
            return null;
        }
        veryLowBattery = this.addVeryLowBattery(timeLine, veryLowBattery, status);
        return veryLowBattery;
    }

    private DeviceTimelineEvent lowBattery(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent lowBattery, DeviceStatus lastStatus, DeviceStatus status, boolean disconnected) {
        if (disconnected && lowBattery != null) {
            lowBattery.end(lastStatus.created());
            return null;
        }
        lowBattery = this.addLowBattery(timeLine, lowBattery, status);
        return lowBattery;
    }

    private boolean addDisconnected(List<DeviceTimelineEvent> timeLine, DeviceStatus lastStatus, DeviceStatus status) {
        if (lastStatus == null || !this.wasDisconnected(status, lastStatus)) {
            return false;
        }
        return timeLine.add(new DeviceTimelineEvent().start(lastStatus.created()).type("background").className("negative").end(status.created()).content("disconnected").id("d" + status.created()).icon("device:signal-cellular-connected-no-internet-0-bar"));
    }

    private DeviceTimelineEvent addUnplugs(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent plugged, DeviceStatus status) {
        if (plugged == null && !status.isPlugged()) {
            plugged = new DeviceTimelineEvent().start(status.created()).id("u" + status.created()).content("unplugged").icon("notification:power");
            timeLine.add(plugged);
        } else if (plugged != null && status.isPlugged()) {
            plugged.end(status.created());
            return null;
        }
        return plugged;
    }

    private DeviceTimelineEvent addScreenOff(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent screenOff, DeviceStatus status) {
        if (screenOff == null && !status.isScreenOn()) {
            screenOff = new DeviceTimelineEvent().start(status.created()).id("s" + status.created()).content("screen off").icon("hardware:tablet");
            timeLine.add(screenOff);
        } else if (screenOff != null && status.isScreenOn()) {
            screenOff.end(status.created());
            return null;
        }
        return screenOff;
    }

    private DeviceTimelineEvent addLowBattery(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent lowBattery, DeviceStatus status) {
        if (lowBattery == null && this.isLowBattery(status.battery())) {
            lowBattery = new DeviceTimelineEvent().start(status.created()).id("lb" + status.created()).content("low battery").icon(DeviceMold.Stamps.BatteryIcon.batteryIcon(status.device()));
            timeLine.add(lowBattery);
        } else if (lowBattery != null && !this.isLowBattery(status.battery())) {
            lowBattery.end(status.created());
            return null;
        }
        return lowBattery;
    }

    private DeviceTimelineEvent addVeryLowBattery(List<DeviceTimelineEvent> timeLine, DeviceTimelineEvent vLowBattery, DeviceStatus status) {
        if (vLowBattery == null && this.isVeryLowBattery(status.battery())) {
            vLowBattery = new DeviceTimelineEvent().start(status.created()).id("vlb" + status.created()).content("very low battery").icon(DeviceMold.Stamps.BatteryIcon.batteryIcon(status.device()));
            timeLine.add(vLowBattery);
        } else if (vLowBattery != null && !this.isVeryLowBattery(status.battery())) {
            vLowBattery.end(status.created());
            return null;
        }
        return vLowBattery;
    }

    private boolean wasDisconnected(DeviceStatus status, DeviceStatus lastStatus) {
        return lastStatus != null && this.disconnected(status.created(), lastStatus.created());
    }

    private boolean disconnected(Instant status, Instant lastStatus) {
        return lastStatus.until(status, ChronoUnit.HOURS) > (long)this.box.graph().configuration().disconnectedTimeThreshold();
    }

    private boolean isLowBattery(double battery) {
        return battery < (double)this.box.graph().configuration().deviceBatteryThreshold();
    }

    private boolean isVeryLowBattery(double battery) {
        return battery < (double)this.box.graph().configuration().deviceLowBatteryThreshold();
    }

    private void addTemperature(List<DeviceTimelineEvent> timeLine, DeviceStatus status) {
        if (status.temperature() >= (double)this.box.graph().configuration().deviceTemperatureThreshold()) {
            timeLine.add(new DeviceTimelineEvent().start(status.created()).content("high temperature").type("point").id("h" + status.created()).icon("social:whatshot"));
        }
    }

    private List<String> byDevice(Device device) {
        return Collections.singletonList(device.core$().id());
    }
}

