/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AbstractDeviceIssueMold;
import io.intino.cesar.box.displays.DeviceMold;
import io.intino.cesar.box.displays.Molds;
import io.intino.cesar.box.displays.SystemIssueMold;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.IssueReport;
import io.intino.cesar.graph.rules.Issue;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;

public class DeviceIssueMold
extends AbstractDeviceIssueMold {
    public DeviceIssueMold(CesarBox box) {
        super(box);
    }

    public static class Stamps {

        public static class DeviceIssueDescription {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Device device = (Device)issueReport.target().a$(Device.class);
                if (device.status() == null) {
                    return "no data";
                }
                StringBuilder builder = new StringBuilder();
                builder.append(" since ").append(String.format("date(%s,LLL)", device.status().created().toEpochMilli())).append(" ");
                if (device.isDisconnected()) {
                    return builder.append(" is disconnected").toString();
                }
                if (device.isHot()) {
                    builder.append(" has ").append(device.status().temperature()).append("\u00b0,");
                }
                if (device.isUnPlugged()) {
                    builder.append(" is unplugged,");
                }
                if (device.lowBattery() || device.veryLowBattery()) {
                    builder.append(" is discharging battery (").append(device.status().battery()).append("%),");
                }
                if (!device.isScreenOn()) {
                    builder.append(" has screen off,");
                }
                String text = builder.toString();
                int ind = (text = text.substring(0, text.length() - 1) + ".").lastIndexOf(",");
                if (ind >= 0) {
                    text = new StringBuilder(text).replace(ind, ind + 1, " and").toString();
                }
                return text;
            }
        }

        public static class Name {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.target().label();
            }
        }

        public static class TimeIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.Disconnected) ? "device:access-time" : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return SystemIssueMold.Stamps.timeTitle(issueReport.ts());
            }
        }

        public static class CpuIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.LimitedCPU) ? "icons:work" : "";
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.LimitedCPU) ? "color:red;" : "color:green;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                DeviceStatus status = ((Device)issueReport.target().a$(Device.class)).status(issueReport.ts());
                return status == null ? null : status.cpuUsage() + " %";
            }
        }

        public static class NoData {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return Molds.noDataIcon(issueReport.target(), issueReport.ts());
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "";
            }
        }

        public static class HotIcon {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.HighTemperature) ? "social:whatshot" : "";
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.HighTemperature) ? "color:red;" : "color:green;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Device device = (Device)issueReport.target().a$(Device.class);
                DeviceStatus status = device.status(issueReport.ts());
                if (status == null) {
                    return "";
                }
                return String.valueOf(status.temperature()) + " \u00ba";
            }
        }

        public static class Unplug {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.Unplugged) ? "notification:power" : "";
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "color:red;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return "unplugged";
            }
        }

        public static class DischargingBattery {
            public static String value(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Issue issue = issueReport.issue();
                Device device = (Device)issueReport.target().a$(Device.class);
                DeviceStatus status = device.status(issueReport.ts());
                return issue.equals((Object)Issue.LowBattery) || issue.equals((Object)Issue.VeryLowBattery) ? DeviceMold.Stamps.BatteryIcon.batteryIcon(status) : null;
            }

            public static String style(CesarBox box, IssueReport issueReport, ActivitySession session) {
                return issueReport.issue().equals((Object)Issue.VeryLowBattery) ? "color:red;" : "color:orange;";
            }

            public static String title(CesarBox box, IssueReport issueReport, ActivitySession session) {
                Device device = (Device)issueReport.target().a$(Device.class);
                return String.format("%.2f", device.status(issueReport.ts()).battery()) + "%";
            }
        }
    }
}

