/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.displays.AbstractDeviceInfoMold;
import io.intino.cesar.box.displays.DeviceMold;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.Feeder;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.TaskOperation;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.ness.inl.Message;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class DeviceInfoMold
extends AbstractDeviceInfoMold {
    public DeviceInfoMold(CesarBox box) {
        super(box);
    }

    public static class Blocks {

        public static class MapBlock {
            public static boolean hidden(Device device) {
                return false;
            }
        }
    }

    public static class Stamps {

        public static class Label {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return device.label();
            }
        }

        public static class Image {
            public static List<URL> value(CesarBox box, Device record, ActivitySession session) {
                try {
                    if (record.i$(Device.class)) {
                        Device device = (Device)record.a$(Device.class);
                        DeviceStatus status = device.status();
                        if (status == null) {
                            return Collections.singletonList(DeviceMold.class.getResource("/images/tablet_no_status.png"));
                        }
                        if (!status.isScreenOn()) {
                            return Collections.singletonList(DeviceMold.class.getResource("/images/tablet_turnoff.png"));
                        }
                        return device.screen().current() != null ? Collections.singletonList(device.screen().current()) : null;
                    }
                    if (record.i$(Feeder.class)) {
                        return Collections.singletonList(DeviceMold.class.getResource("/images/pi.png"));
                    }
                    return Collections.emptyList();
                }
                catch (Throwable e) {
                    return Collections.emptyList();
                }
            }
        }

        public static class Shutdown {
            public static String style(CesarBox box, Device device, ActivitySession session) {
                return device.isDisconnected() ? "display:none" : "";
            }

            public static TaskOperation.Refresh execute(CesarBox box, Device device, String selfId, ActivitySession session) {
                return TaskOperation.Refresh.None;
            }

            public static String drawingColor(CesarBox box, Device object, ActivitySession session) {
                return null;
            }
        }

        public static class Reboot {
            public static String style(CesarBox box, Device device, ActivitySession session) {
                return Shutdown.style(box, device, session);
            }

            public static TaskOperation.Refresh execute(CesarBox box, Device device, String selfId, ActivitySession session) {
                return TaskOperation.Refresh.None;
            }

            public static String drawingColor(CesarBox box, Device object, ActivitySession session) {
                return null;
            }
        }

        public static class Mapa {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return null;
            }
        }

        public static class Refresh {
            public static TaskOperation.Refresh execute(CesarBox box, Device device, String selfId, ActivitySession session) {
                String response = Query.DeviceHelper.commander(box, device).status();
                if (Query.DeviceHelper.valid(response)) {
                    Status status = MessageManager.fromInl(response, Status.class).get(0);
                    NessTanks.deviceStatus().feed(Message.load((String)MessageManager.toInl(status)));
                    return TaskOperation.Refresh.Item;
                }
                return TaskOperation.Refresh.None;
            }

            public static String drawingColor(CesarBox box, Device object, ActivitySession session) {
                return null;
            }
        }

        public static class Consul {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "Consul";
            }
        }

        public static class ConsulVersion {
            public static String value(CesarBox box, Device device, ActivitySession session) {
                return "v." + device.consul().version();
            }
        }

        public static class Update {
            public static TaskOperation.Refresh execute(CesarBox box, Device device, String selfId, ActivitySession session) {
                return TaskOperation.Refresh.None;
            }

            public static String drawingColor(CesarBox box, Device object, ActivitySession session) {
                return null;
            }
        }
    }
}

