/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.notifiers.CesarSystemLogNotifier;
import io.intino.cesar.box.schemas.SystemLog;
import io.intino.cesar.graph.System;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class CesarSystemLog
extends AlexandriaStamp<CesarSystemLogNotifier> {
    private CesarBox box;
    private int page = 0;
    private static final int PageSize = 15;

    public CesarSystemLog(CesarBox box) {
        this.box = box;
    }

    public void refresh() {
        super.refresh();
        this.page = 0;
        ((CesarSystemLogNotifier)this.notifier).clear();
        ((CesarSystemLogNotifier)this.notifier).refresh(this.systemLog());
    }

    private SystemLog systemLog() {
        System system = (System)((Object)this.item().object());
        try {
            if (system.registry().log() == null) {
                return null;
            }
            String log = new String(IOUtils.toByteArray((InputStream)system.registry().log().openStream()));
            List<String> messages = Arrays.asList(log.split("\\[log]"));
            Collections.reverse(messages);
            List<String> collect = this.currentPageMessages(messages).stream().map(this::customize).collect(Collectors.toList());
            return new SystemLog().items(collect).hasNextPage(this.hasNextPage(messages.size()));
        }
        catch (IOException e) {
            Logger.getRootLogger().error((Object)e.getMessage(), (Throwable)e);
            return new SystemLog();
        }
    }

    private List<String> currentPageMessages(List<String> messages) {
        return messages.size() > 15 ? messages.subList(this.page * 15, (this.page + 1) * 15 < messages.size() ? (this.page + 1) * 15 : messages.size()) : messages;
    }

    private String customize(String m) {
        StringBuilder text = new StringBuilder();
        if (m.contains("\nlevel: ERROR")) {
            text.append("<pre style='color:red;font-size:10pt'>");
        } else if (m.contains("\nlevel: WARN")) {
            text.append("<pre style='color:darkorange;font-size:10pt'>");
        } else {
            text.append("<pre style='font-size:10pt;'>");
        }
        text.append(m).append("</pre>");
        return text.toString();
    }

    private int countPages(int totalMessages) {
        return Math.round((long)totalMessages / 15L) + ((long)totalMessages % 15L > 0L ? 1 : 0);
    }

    private boolean hasNextPage(int totalMessages) {
        return this.page < this.countPages(totalMessages) - 1;
    }

    public void showMore() {
        ++this.page;
        ((CesarSystemLogNotifier)this.notifier).refresh(this.systemLog());
    }
}

