/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.SystemCatalog;
import io.intino.cesar.box.displays.notifiers.SystemCatalogNotifier;
import io.intino.cesar.graph.System;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.catalog.events.OpenPanel;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import io.intino.konos.alexandria.activity.model.toolbar.TaskSelection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSystemCatalog
extends AlexandriaCatalog<SystemCatalogNotifier> {
    public AbstractSystemCatalog(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractSystemCatalog.buildCatalog(box));
    }

    private static Catalog buildCatalog(CesarBox box) {
        Catalog catalog = new Catalog();
        catalog.objectsLoader((scope, condition, session) -> SystemCatalog.Source.systemList(box, scope, condition, session));
        catalog.events(new Events().onClickRecord(new OnClickRecord().openPanel(new OpenPanel().panel((Panel)Displays.displayFor(box, "cesarSystemPanel").element()))));
        catalog.toolbar(AbstractSystemCatalog.buildToolbar(box));
        catalog.name("systemCatalog").label("Systems");
        catalog.objectLoader((id, session) -> SystemCatalog.Source.system(box, id, session)).objectIdLoader(object -> SystemCatalog.Source.systemId(box, (System)((Object)((Object)object)))).objectNameLoader(object -> SystemCatalog.Source.systemName(box, (System)((Object)((Object)object))));
        AbstractSystemCatalog.buildViews(box).forEach(v -> catalog.add(v));
        AbstractSystemCatalog.buildArrangements(box).forEach(a -> catalog.add(a));
        return catalog;
    }

    private static Toolbar buildToolbar(CesarBox box) {
        Toolbar toolbar = new Toolbar();
        toolbar.canSearch(false);
        toolbar.add(new TaskSelection().execute((element, option, selection, session) -> SystemCatalog.Toolbar.taskSelection(box, element, option, selection, session)).name("a4f11190-a53c-4910-86f9-00774406bd56").title("remove elements").alexandriaIcon("icons:remove"));
        return toolbar;
    }

    private static List<AbstractView> buildViews(CesarBox box) {
        ArrayList<AbstractView> result = new ArrayList<AbstractView>();
        result.add(new ListView().noRecordsMessage("There is no systems").width(100).mold((Mold)Displays.displayFor(box, "systemPreviewMold").element()).name("fe1049fa-1bad-4afd-a3bd-98cae11e4164").label("List"));
        return result;
    }

    private static List<Arrangement> buildArrangements(CesarBox box) {
        ArrayList<Arrangement> arrangements = new ArrayList<Arrangement>();
        return arrangements;
    }
}

