/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.dialogs.Dialogs;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.ServerIssuesCatalog;
import io.intino.cesar.box.displays.notifiers.ServerIssuesCatalogNotifier;
import io.intino.cesar.graph.IssueReport;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.catalog.events.OpenDialog;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import io.intino.konos.alexandria.activity.model.toolbar.TaskSelection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractServerIssuesCatalog
extends AlexandriaCatalog<ServerIssuesCatalogNotifier> {
    public AbstractServerIssuesCatalog(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractServerIssuesCatalog.buildCatalog(box));
    }

    private static Catalog buildCatalog(CesarBox box) {
        Catalog catalog = new Catalog();
        catalog.objectsLoader((scope, condition, session) -> ServerIssuesCatalog.Source.issueReportList(box, scope, condition, session));
        catalog.events(new Events().onClickRecord(new OnClickRecord().openDialog(new OpenDialog().height(50).width(80).dialogType("issueDialog").dialogBuilder((item, session) -> {
            AlexandriaDialog dialog = Dialogs.dialogFor(box, "issueDialog");
            dialog.target(item);
            return dialog;
        }))));
        catalog.toolbar(AbstractServerIssuesCatalog.buildToolbar(box));
        catalog.name("serverIssuesCatalog").label("Server Issues");
        catalog.objectLoader((id, session) -> ServerIssuesCatalog.Source.issueReport(box, id, session)).objectIdLoader(object -> ServerIssuesCatalog.Source.issueReportId(box, (IssueReport)((Object)((Object)object)))).objectNameLoader(object -> ServerIssuesCatalog.Source.issueReportName(box, (IssueReport)((Object)((Object)object))));
        AbstractServerIssuesCatalog.buildViews(box).forEach(v -> catalog.add(v));
        AbstractServerIssuesCatalog.buildArrangements(box).forEach(a -> catalog.add(a));
        return catalog;
    }

    private static Toolbar buildToolbar(CesarBox box) {
        Toolbar toolbar = new Toolbar();
        toolbar.canSearch(false);
        toolbar.add(new TaskSelection().execute((element, option, selection, session) -> ServerIssuesCatalog.Toolbar.taskSelection(box, element, option, selection, session)).name("29053a5c-c27d-4ce4-9b70-d19f29037487").title("remove elements").alexandriaIcon("icons:remove"));
        return toolbar;
    }

    private static List<AbstractView> buildViews(CesarBox box) {
        ArrayList<AbstractView> result = new ArrayList<AbstractView>();
        result.add(new ListView().noRecordsMessage("no issues to show").width(100).mold((Mold)Displays.displayFor(box, "serverIssueMold").element()).name("list").label("List"));
        return result;
    }

    private static List<Arrangement> buildArrangements(CesarBox box) {
        ArrayList<Arrangement> arrangements = new ArrayList<Arrangement>();
        arrangements.add(new Sorting().comparator((object1, object2) -> ServerIssuesCatalog.Arrangements.sortingComparator((IssueReport)((Object)((Object)object1)), (IssueReport)((Object)((Object)object2)))).visible(false).name("sorting").label(""));
        return arrangements;
    }
}

