/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.MainMenu;
import io.intino.cesar.box.displays.notifiers.MainMenuNotifier;
import io.intino.cesar.graph.Project;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaMenuLayout;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.ElementRender;
import io.intino.konos.alexandria.activity.model.Layout;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.layout.ElementOption;
import io.intino.konos.alexandria.activity.model.layout.options.Group;
import io.intino.konos.alexandria.activity.model.layout.options.Option;
import io.intino.konos.alexandria.activity.model.layout.options.Options;
import io.intino.konos.alexandria.activity.model.renders.RenderObjects;
import io.intino.konos.alexandria.activity.model.renders.RenderPanels;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMainMenu
extends AlexandriaMenuLayout<MainMenuNotifier> {
    public AbstractMainMenu(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractMainMenu.buildLayout(box));
    }

    private static Layout buildLayout(final CesarBox box) {
        Layout layout = new Layout();
        layout.mode(Layout.Mode.Menu);
        layout.elementDisplayBuilder(new Layout.ElementDisplayBuilder(){

            public AlexandriaElementDisplay displayFor(Element element, Object o) {
                return this.get(element, o);
            }

            public Class<? extends AlexandriaElementDisplay> displayTypeFor(Element element, Object o) {
                return this.get(element, o).getClass();
            }

            private AlexandriaElementDisplay get(Element element, Object o) {
                return Displays.displayFor(box, element);
            }
        });
        AbstractMainMenu.buildOptions(box).forEach(arg_0 -> ((Layout)layout).add(arg_0));
        return layout;
    }

    private static List<ElementOption> buildOptions(CesarBox box) {
        ArrayList<ElementOption> result = new ArrayList<ElementOption>();
        result.add((ElementOption)new Option().label("overview").render((ElementRender)new RenderPanels().panels(Displays.elementsFor(box, Panel.class, "overviewPanel"))));
        result.add((ElementOption)new Group().label("projects").mode(Group.Mode.Expanded).add((ElementOption)new Options().label((element, object) -> MainMenu.Projects.ProjectOptions.label(box, element, (Project)((Object)((Object)object)))).icon((element, object) -> MainMenu.Projects.ProjectOptions.icon(box, element, (Project)((Object)((Object)object)))).bubble((element, object) -> MainMenu.Projects.ProjectOptions.bubble(box, element, (Project)((Object)((Object)object)))).render((ElementRender)new RenderObjects().panel((Panel)Displays.displayFor(box, "projectPanel").element()).source(session -> MainMenu.Projects.ProjectOptions.objects(box, session)))));
        result.add((ElementOption)new Option().label("administration").render((ElementRender)new RenderPanels().panels(Displays.elementsFor(box, Panel.class, "adminPanel"))));
        return result;
    }
}

