/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.HistoryCatalog;
import io.intino.cesar.box.displays.notifiers.HistoryCatalogNotifier;
import io.intino.cesar.graph.IssueReport;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHistoryCatalog
extends AlexandriaCatalog<HistoryCatalogNotifier> {
    public AbstractHistoryCatalog(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractHistoryCatalog.buildCatalog(box));
    }

    private static Catalog buildCatalog(CesarBox box) {
        Catalog catalog = new Catalog();
        catalog.objectsLoader((scope, condition, session) -> HistoryCatalog.Source.issueReportList(box, scope, condition, session));
        catalog.toolbar(AbstractHistoryCatalog.buildToolbar(box));
        catalog.name("historyCatalog").label("History");
        catalog.objectLoader((id, session) -> HistoryCatalog.Source.issueReport(box, id, session)).objectIdLoader(object -> HistoryCatalog.Source.issueReportId(box, (IssueReport)((Object)((Object)object)))).objectNameLoader(object -> HistoryCatalog.Source.issueReportName(box, (IssueReport)((Object)((Object)object))));
        AbstractHistoryCatalog.buildViews(box).forEach(v -> catalog.add(v));
        AbstractHistoryCatalog.buildArrangements(box).forEach(a -> catalog.add(a));
        return catalog;
    }

    private static Toolbar buildToolbar(CesarBox box) {
        Toolbar toolbar = new Toolbar();
        toolbar.canSearch(false);
        return toolbar;
    }

    private static List<AbstractView> buildViews(CesarBox box) {
        ArrayList<AbstractView> result = new ArrayList<AbstractView>();
        result.add(new ListView().noRecordsMessage("no solved issues").width(100).mold((Mold)Displays.displayFor(box, "issueMold").element()).name("list").label("List"));
        return result;
    }

    private static List<Arrangement> buildArrangements(CesarBox box) {
        ArrayList<Arrangement> arrangements = new ArrayList<Arrangement>();
        arrangements.add(new Sorting().comparator((object1, object2) -> HistoryCatalog.Arrangements.sorterComparator((IssueReport)((Object)((Object)object1)), (IssueReport)((Object)((Object)object2)))).visible(true).name("sorter").label("date"));
        return arrangements;
    }
}

