/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.dialogs.Dialogs;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.FeederIssuesCatalog;
import io.intino.cesar.box.displays.notifiers.FeederIssuesCatalogNotifier;
import io.intino.cesar.graph.IssueReport;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.catalog.events.OpenDialog;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFeederIssuesCatalog
extends AlexandriaCatalog<FeederIssuesCatalogNotifier> {
    public AbstractFeederIssuesCatalog(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractFeederIssuesCatalog.buildCatalog(box));
    }

    private static Catalog buildCatalog(CesarBox box) {
        Catalog catalog = new Catalog();
        catalog.objectsLoader((scope, condition, session) -> FeederIssuesCatalog.Source.issueReportList(box, scope, condition, session));
        catalog.events(new Events().onClickRecord(new OnClickRecord().openDialog(new OpenDialog().height(50).width(80).dialogType("issueDialog").dialogBuilder((item, session) -> {
            AlexandriaDialog dialog = Dialogs.dialogFor(box, "issueDialog");
            dialog.target(item);
            return dialog;
        }))));
        catalog.toolbar(AbstractFeederIssuesCatalog.buildToolbar(box));
        catalog.name("feederIssuesCatalog").label("Feeder Issues");
        catalog.objectLoader((id, session) -> FeederIssuesCatalog.Source.issueReport(box, id, session)).objectIdLoader(object -> FeederIssuesCatalog.Source.issueReportId(box, (IssueReport)((Object)((Object)object)))).objectNameLoader(object -> FeederIssuesCatalog.Source.issueReportName(box, (IssueReport)((Object)((Object)object))));
        AbstractFeederIssuesCatalog.buildViews(box).forEach(v -> catalog.add(v));
        AbstractFeederIssuesCatalog.buildArrangements(box).forEach(a -> catalog.add(a));
        return catalog;
    }

    private static Toolbar buildToolbar(CesarBox box) {
        Toolbar toolbar = new Toolbar();
        toolbar.canSearch(false);
        return toolbar;
    }

    private static List<AbstractView> buildViews(CesarBox box) {
        ArrayList<AbstractView> result = new ArrayList<AbstractView>();
        result.add(new ListView().noRecordsMessage("no issues to show").width(100).mold((Mold)Displays.displayFor(box, "serverIssueMold").element()).name("list").label("List"));
        return result;
    }

    private static List<Arrangement> buildArrangements(CesarBox box) {
        ArrayList<Arrangement> arrangements = new ArrayList<Arrangement>();
        arrangements.add(new Sorting().comparator((object1, object2) -> FeederIssuesCatalog.Arrangements.sortingComparator((IssueReport)((Object)((Object)object1)), (IssueReport)((Object)((Object)object2)))).visible(false).name("sorting").label(""));
        return arrangements;
    }
}

