/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.DeviceCatalog;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.notifiers.DeviceCatalogNotifier;
import io.intino.cesar.graph.Device;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.catalog.events.OpenPanel;
import io.intino.konos.alexandria.activity.model.catalog.views.DisplayView;
import io.intino.konos.alexandria.activity.model.catalog.views.GridView;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import io.intino.konos.alexandria.activity.model.toolbar.TaskSelection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDeviceCatalog
extends AlexandriaCatalog<DeviceCatalogNotifier> {
    public AbstractDeviceCatalog(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractDeviceCatalog.buildCatalog(box));
    }

    private static Catalog buildCatalog(CesarBox box) {
        Catalog catalog = new Catalog();
        catalog.objectsLoader((scope, condition, session) -> DeviceCatalog.Source.deviceList(box, scope, condition, session));
        catalog.events(new Events().onClickRecord(new OnClickRecord().openPanel(new OpenPanel().panel((Panel)Displays.displayFor(box, "cesarDevicePanel").element()))));
        catalog.arrangementFiltererLoader(session -> DeviceCatalog.Arrangements.filterer(box, session));
        catalog.arrangementHistogramsMode("EnabledButHidden");
        catalog.toolbar(AbstractDeviceCatalog.buildToolbar(box));
        catalog.name("deviceCatalog").label("Devices");
        catalog.objectLoader((id, session) -> DeviceCatalog.Source.device(box, id, session)).objectIdLoader(object -> DeviceCatalog.Source.deviceId(box, (Device)((Object)((Object)object)))).objectNameLoader(object -> DeviceCatalog.Source.deviceName(box, (Device)((Object)((Object)object))));
        AbstractDeviceCatalog.buildViews(box).forEach(v -> catalog.add(v));
        AbstractDeviceCatalog.buildArrangements(box).forEach(a -> catalog.add(a));
        return catalog;
    }

    private static Toolbar buildToolbar(CesarBox box) {
        Toolbar toolbar = new Toolbar();
        toolbar.canSearch(true);
        toolbar.add(new TaskSelection().execute((element, option, selection, session) -> DeviceCatalog.Toolbar.taskSelection(box, element, option, selection, session)).name("a0c5dda2-7691-4402-a1b5-001cda10228f").title("remove elements").alexandriaIcon("icons:remove"));
        return toolbar;
    }

    private static List<AbstractView> buildViews(CesarBox box) {
        ArrayList<AbstractView> result = new ArrayList<AbstractView>();
        result.add(new ListView().width(100).mold((Mold)Displays.displayFor(box, "devicePreviewMold").element()).name("e5302fee-b8c9-413c-bd82-100a2677738d").label("List"));
        result.add(new GridView().width(100).mold((Mold)Displays.displayFor(box, "devicePreviewGridMold").element()).name("fb07f026-b14d-4afe-8e03-217a9798203a").label("Grid"));
        result.add(new DisplayView().scopeManager((display, scope) -> DeviceCatalog.Views.cesarOlapScope(box, display, scope)).hideNavigator(true).displayLoader((context, loadingListener, instantListener, session) -> DeviceCatalog.Views.cesarOlap(box, (Element)context, loadingListener, instantListener, session)).name("00669bb5-cec0-4de1-b3c8-d010b000626e").label("Charts"));
        return result;
    }

    private static List<Arrangement> buildArrangements(CesarBox box) {
        ArrayList<Arrangement> arrangements = new ArrayList<Arrangement>();
        arrangements.add(new Grouping().histogram(Grouping.Histogram.Percentage).groups((objects, session) -> DeviceCatalog.Arrangements.statusCategorization(box, objects, session)).name("statusCategorization").label("by Status"));
        return arrangements;
    }
}

