/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.displays;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.AssetCatalog;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.displays.notifiers.AssetCatalogNotifier;
import io.intino.cesar.graph.Asset;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping;
import io.intino.konos.alexandria.activity.model.catalog.views.DisplayView;
import io.intino.konos.alexandria.activity.model.catalog.views.GridView;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import io.intino.konos.alexandria.activity.model.toolbar.TaskSelection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAssetCatalog
extends AlexandriaCatalog<AssetCatalogNotifier> {
    public AbstractAssetCatalog(CesarBox box) {
        super((Box)box);
        this.element((Element)AbstractAssetCatalog.buildCatalog(box));
    }

    private static Catalog buildCatalog(CesarBox box) {
        Catalog catalog = new Catalog();
        catalog.objectsLoader((scope, condition, session) -> AssetCatalog.Source.assetList(box, scope, condition, session));
        catalog.arrangementFiltererLoader(session -> AssetCatalog.Arrangements.filterer(box, session));
        catalog.arrangementHistogramsMode("EnabledButHidden");
        catalog.toolbar(AbstractAssetCatalog.buildToolbar(box));
        catalog.name("assetCatalog").label("Assets");
        catalog.objectLoader((id, session) -> AssetCatalog.Source.asset(box, id, session)).objectIdLoader(object -> AssetCatalog.Source.assetId(box, (Asset)((Object)((Object)object)))).objectNameLoader(object -> AssetCatalog.Source.assetName(box, (Asset)((Object)((Object)object))));
        AbstractAssetCatalog.buildViews(box).forEach(v -> catalog.add(v));
        AbstractAssetCatalog.buildArrangements(box).forEach(a -> catalog.add(a));
        return catalog;
    }

    private static Toolbar buildToolbar(CesarBox box) {
        Toolbar toolbar = new Toolbar();
        toolbar.canSearch(true);
        toolbar.add(new TaskSelection().execute((element, option, selection, session) -> AssetCatalog.Toolbar.taskSelection(box, element, option, selection, session)).name("6bceb232-ef44-43a0-be46-3f6dd13d0f38").title("remove elements").alexandriaIcon("icons:remove"));
        return toolbar;
    }

    private static List<AbstractView> buildViews(CesarBox box) {
        ArrayList<AbstractView> result = new ArrayList<AbstractView>();
        result.add(new ListView().width(90).mold((Mold)Displays.displayFor(box, "devicePreviewMold").element()).name("d0a6fb15-6ff6-43cb-b112-e9efc8fc3f4b").label("List"));
        result.add(new GridView().width(90).mold((Mold)Displays.displayFor(box, "devicePreviewGridMold").element()).name("2fd716f6-84e4-41c9-9342-8f1eee4803a8").label("Grid"));
        result.add(new DisplayView().scopeManager((display, scope) -> AssetCatalog.Views.cesarOlapScope(box, display, scope)).hideNavigator(true).displayLoader((context, loadingListener, instantListener, session) -> AssetCatalog.Views.cesarOlap(box, (Element)context, loadingListener, instantListener, session)).name("9ab4422a-4f99-4a90-afff-2cfc9a0e4f9d").label("Charts"));
        return result;
    }

    private static List<Arrangement> buildArrangements(CesarBox box) {
        ArrayList<Arrangement> arrangements = new ArrayList<Arrangement>();
        arrangements.add(new Grouping().histogram(Grouping.Histogram.Percentage).groups((objects, session) -> AssetCatalog.Arrangements.unitCategorization(box, objects, session)).name("unitCategorization").label("by Unit"));
        arrangements.add(new Grouping().histogram(Grouping.Histogram.Percentage).groups((objects, session) -> AssetCatalog.Arrangements.statusCategorization(box, objects, session)).name("statusCategorization").label("by Status"));
        return arrangements;
    }
}

