/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.dialogs;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.dialogs.AbstractIssueDialog;
import io.intino.cesar.box.displays.ProjectPanel;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.IssueReport;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelCatalogView;
import io.intino.konos.alexandria.activity.displays.DialogExecution;
import io.intino.konos.alexandria.activity.displays.Soul;
import io.intino.konos.alexandria.activity.model.Dialog;
import io.intino.konos.alexandria.activity.services.push.ActivityClient;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.util.TimeZone;

public class IssueDialog
extends AbstractIssueDialog {
    private IssueReport report;
    private Identifiable target;

    public IssueDialog(CesarBox box) {
        super(box);
    }

    public void target(Object target) {
        super.target(target);
        this.report = (IssueReport)((Object)target);
        this.target = this.report.target();
    }

    public void prepare() {
        this.dialog().label(this.dialog().label() + " on " + this.target.label());
        this.dialog().description("");
        this.dialog().input("Issue id").value((Object)this.report.name$());
        this.dialog().input("Issue").value((Object)this.report.issue().name());
        this.dialog().input("level").value((Object)this.report.level().name());
        this.dialog().input("instant").value((Object)SlackMessageFormatter.formatInstant(TimeZone.getDefault().getID(), this.report.ts()));
        if (this.report.log() != null) {
            this.dialog().input("remarks").value((Object)("<pre><b>Source class:</b> " + this.report.log().sourceClass() + "\n<b>Source method:</b> " + this.report.log().sourceMethod() + "</pre>"));
            this.dialog().input("log").value((Object)("<pre>" + this.report.log().stack() + "</pre>"));
        } else {
            this.dialog().input("remarks").visible(false);
            this.dialog().input("log").visible(false);
        }
        this.dialog().toolbar().operation("go to item").label("go to " + ((Object)((Object)this.target)).getClass().getSimpleName().toLowerCase());
    }

    public static class Toolbar {
        static DialogExecution.Modification resolveIssue(CesarBox box, Dialog dialog, Dialog.Toolbar.Operation operation, ActivitySession session) {
            IssueReport issue = (IssueReport)((Object)dialog.target());
            issue.status(IssueReport.Status.Solved);
            issue.save$();
            ((ActivityClient)session.client()).soul().moldsWithTarget(issue.target().core$().id()).forEach(AlexandriaDisplay::refresh);
            return DialogExecution.Modification.None;
        }

        static DialogExecution.Modification discardIssue(CesarBox box, Dialog dialog, Dialog.Toolbar.Operation operation, ActivitySession session) {
            IssueReport issue = (IssueReport)((Object)dialog.target());
            issue.status(IssueReport.Status.Closed);
            issue.save$();
            ((ActivityClient)session.client()).soul().moldsWithTarget(issue.target().core$().id()).forEach(AlexandriaDisplay::refresh);
            return DialogExecution.Modification.None;
        }

        static DialogExecution.Modification gotoItem(CesarBox box, Dialog dialog, Dialog.Toolbar.Operation operation, ActivitySession session) {
            Soul soul = ((ActivityClient)session.client()).soul();
            IssueReport issue = (IssueReport)((Object)dialog.target());
            ProjectPanel display = (ProjectPanel)soul.desktop().openElement("happysense");
            AlexandriaPanelCatalogView view = (AlexandriaPanelCatalogView)display.selectView("devices");
            AlexandriaCatalog catalog = (AlexandriaCatalog)view.catalogDisplay();
            catalog.openItem(issue.target().core$().id());
            return DialogExecution.Modification.None;
        }
    }
}

