/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.commanders;

import io.intino.cesar.Utils;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.ness.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.System;
import io.intino.consul.schemas.Artifactory;
import io.intino.consul.schemas.Parameter;
import io.intino.consul.schemas.SystemSchema;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.jms.JMSException;

public class SystemDeployer {
    private final CesarBox box;
    private final ServerConsul consul;
    private final io.intino.cesar.box.schemas.SystemSchema system;
    private final String user;

    public SystemDeployer(CesarBox box, ServerConsul consul, io.intino.cesar.box.schemas.SystemSchema system, String user) {
        this.box = box;
        this.consul = consul;
        this.system = system;
        this.user = user;
    }

    public void deploy() throws IOException, JMSException {
        Server server = (Server)this.consul.core$().ownerAs(Server.class);
        this.configureProxy(this.system.publicURL(), server);
        System system = this.findSystem();
        if (Query.ServerHelper.commander(this.box.datalake(), server).deploy(this.consulSchema(system, server))) {
            this.registerSystemAndDeploy(system);
            this.notifyResult("System " + this.system.packaging().artifact() + " has been deployed to " + server.name$() + " successfully.");
        } else {
            this.notifyResult("Error deploying " + this.system.packaging().artifact() + " in " + server.name$());
        }
    }

    private void notifyResult(String message) {
        this.box.cesarBot().sendToUser(this.user, message);
    }

    private SystemSchema consulSchema(System system, Server server) {
        SystemSchema schema = new SystemSchema();
        schema.name(Utils.normalizedID(this.system.name()));
        schema.project(this.system.project());
        schema.artifact(this.system.packaging().artifact());
        schema.classpathPrefix(this.system.packaging().classpathPrefix());
        schema.parameterList(this.system.packaging().parameterList().stream().map(p -> new Parameter().name(p.name()).value(p.value())).collect(Collectors.toList()));
        schema.artifactoryList(this.system.artifactoryList().stream().map(a -> new Artifactory().id(a.id()).url(a.url()).user(a.user()).password(a.password())).collect(Collectors.toList()));
        if (system != null && system.operations().port() != 0) {
            schema.jmxPort(Integer.valueOf(system.operations().port()));
        } else {
            this.system.jmxPort(server.reserveJMXPort());
            schema.jmxPort(this.system.jmxPort());
        }
        return schema;
    }

    private void configureProxy(String systemURL, Server server) {
    }

    private void registerSystemAndDeploy(System system) {
        if (system == null) {
            ChangeCommitter.commit(InfrastructureOperation.message("Add", this.user, "System", null, MessageManager.gson().toJson((Object)this.system)));
        }
        ChangeCommitter.commit(InfrastructureOperation.message("NewDeployment", this.user, "System", this.system.name(), MessageManager.gson().toJson((Object)this.system)));
    }

    private System findSystem() {
        Project project = this.box.graph().projectList(p -> p.name$().equals(this.system.project())).findFirst().orElse(null);
        if (project == null) {
            return null;
        }
        for (System s : project.systemList()) {
            if (!s.name$().equals(this.consul.core$().owner().name() + ":" + Utils.normalizedID(this.system.name()))) continue;
            return s;
        }
        return null;
    }
}

