/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.commanders;

import io.intino.cesar.graph.AbstractSystem;
import io.intino.cesar.graph.Project;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.consul.ConsulJMSAccessor;
import io.intino.consul.schemas.Operation;
import io.intino.consul.schemas.OperationResult;
import io.intino.consul.schemas.SystemLog;
import io.intino.consul.schemas.SystemStatus;
import io.intino.konos.datalake.Ness;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import org.apache.log4j.Logger;

public class SystemCommander {
    private static final Logger logger = Logger.getRootLogger();
    private final Ness datalake;
    private final System system;
    private final Project project;

    public SystemCommander(Ness datalake, System system) {
        this.datalake = datalake;
        this.system = system;
        this.project = (Project)system.core$().ownerAs(Project.class);
    }

    public SystemLog log() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.systemLog(this.project.name$(), this.system.label(), log -> {
                result[0] = log;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            return result[0] == null ? null : (SystemLog)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            return (SystemLog)result[0];
        }
    }

    public SystemStatus status() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.systemStatus(this.project.name$(), this.system.label(), status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            return result[0] == null ? null : (SystemStatus)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            return (SystemStatus)result[0];
        }
    }

    public OperationResult operation(Operation operation) {
        Object[] result = new Object[]{null};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.systemOperation(this.project.name$(), this.system.label(), operation, value -> {
                result[0] = value;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            consumer.close();
            return result[0] == null ? null : (OperationResult)result[0];
        }
        catch (InterruptedException | JMSException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            return (OperationResult)result[0];
        }
    }

    private ConsulJMSAccessor accessor() {
        if (this.system.consul() == null) {
            return null;
        }
        return new ConsulJMSAccessor(this.datalake.session(), ((Server)this.system.consul().core$().ownerAs(Server.class)).name$());
    }

    public Boolean start() {
        Object[] result = new Object[]{false};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.startSystem(this.project.name$(), this.system.label(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            return (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }

    public Boolean stop() {
        Object[] result = new Object[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.stopSystem(this.project.name$(), this.system.label(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            return (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            try {
                consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return (Boolean)result[0];
        }
    }

    public Boolean restart() {
        Object[] result = new Object[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.restartSystem(this.project.name$(), this.system.label(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            consumer.close();
            return (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            try {
                consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return (Boolean)result[0];
        }
    }

    public Boolean debug() {
        Object[] result = new Object[]{false};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.debugSystem(this.project.name$(), this.system.label(), Integer.valueOf(this.system.debugPort()), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            consumer.close();
            return (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            try {
                consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return (Boolean)result[0];
        }
    }

    public List<Operation> operations() {
        Object[] result = new Object[]{null};
        MessageConsumer consumer = null;
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            consumer = accessor.systemOperations(this.project.name$(), this.system.label(), value -> {
                result[0] = value;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            consumer.close();
            return result[0] == null ? null : (List)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            try {
                consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return (List)result[0];
        }
    }

    public Boolean parameter(System system, String name, String value) {
        ConsulJMSAccessor accessor;
        Thread thread = Thread.currentThread();
        Object[] result = new Object[]{null};
        List<AbstractSystem.Deployment.Parameter> parameters = system.deployment(system.deploymentList().size() - 1).parameterList();
        AbstractSystem.Deployment.Parameter parameter = parameters.stream().filter(p -> p.name$().equals(name)).findFirst().orElse(null);
        if (parameter != null) {
            parameter.value(value);
        }
        if ((accessor = this.accessor()) == null) {
            return null;
        }
        try {
            accessor.parameter(this.project.name$(), system.label(), name, value, success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(5000L);
            return result[0] == null ? null : (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }
}

