/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.commanders;

import io.intino.cesar.graph.Server;
import io.intino.consul.ConsulJMSAccessor;
import io.intino.consul.schemas.ServerStatus;
import io.intino.consul.schemas.SystemSchema;
import io.intino.konos.datalake.Ness;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQSession;

public class ServerCommander {
    private Ness datalake;
    private Server server;

    public ServerCommander(Ness datalake, Server server) {
        this.datalake = datalake;
        this.server = server;
    }

    public ServerStatus status() {
        Object[] result = new Object[]{false};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.status(status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (ServerStatus)result[0];
        }
        catch (InterruptedException | JMSException e) {
            return (ServerStatus)result[0];
        }
    }

    public boolean reboot() {
        Boolean[] result = new Boolean[]{false};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return false;
            }
            accessor.reboot(status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            return result[0];
        }
    }

    public boolean parameter(String system, String project, String name, String value) {
        Boolean[] result = new Boolean[]{false};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return false;
            }
            accessor.parameter(project, system, name, value, v -> {
                result[0] = v;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            return result[0];
        }
    }

    public boolean deploy(SystemSchema schema) {
        Boolean[] result = new Boolean[]{false};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return false;
            }
            accessor.deploy(schema, v -> {
                result[0] = v;
                thread.interrupt();
            });
            Thread.sleep(600000L);
            return result[0];
        }
        catch (InterruptedException | JMSException e) {
            return result[0];
        }
    }

    public Boolean shutdown() {
        return false;
    }

    public ConsulJMSAccessor accessor() {
        if (this.server.serverConsul() == null) {
            return null;
        }
        if (this.datalake.session() == null || ((ActiveMQSession)this.datalake.session()).isClosed()) {
            this.datalake.start();
        }
        return new ConsulJMSAccessor(this.datalake.session(), ((Server)this.server.serverConsul().core$().ownerAs(Server.class)).name$());
    }
}

