/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.displays.Displays;
import io.intino.cesar.box.slack.helpers.ImageHelper;
import io.intino.cesar.checkers.DeviceStatusChecker;
import io.intino.cesar.checkers.ScreenDownloader;
import io.intino.cesar.checkers.ServerStatusChecker;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Server;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.sumus.box.SumusBox;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleAssetCheckerAction {
    public CesarBox box;
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");

    public void execute() {
        this.box.graph().assetList().forEach(unit -> {
            if (unit.core$().is(Device.class)) {
                Device device = (Device)unit.core$().as(Device.class);
                if (device.status() != null && device.isScreenOn()) {
                    this.downloadScreen(device);
                }
                device.update(d -> {
                    AlexandriaElementDisplay assetCatalog = Displays.displayFor(this.box, "assetCatalog");
                    if (assetCatalog != null) {
                        ((SumusBox)this.box.owner()).refreshDisplaysOf((Catalog)assetCatalog.element(), false, new Item[]{new Item().id(d.core$().id()).name(d.name$()).object((Object)d)});
                    }
                });
                try {
                    new DeviceStatusChecker(device, this.box).check();
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            } else {
                new ServerStatusChecker((Server)unit.core$().as(Server.class), this.box).check();
            }
        });
    }

    private void downloadScreen(Device device) {
        byte[] image = new ScreenDownloader(this.box).screenOf(device);
        if (image != null && image.length != 0) {
            BufferedImage withTimeMark = ImageHelper.withTimeMark(device.screen(), image);
            if (withTimeMark == null) {
                logger.error("image of " + device.label() + " is null");
                return;
            }
            device.screen().save(ImageHelper.decodeImage(withTimeMark));
        }
    }
}

