/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.commanders.SystemDeployer;
import io.intino.cesar.box.schemas.SystemSchema;
import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.konos.alexandria.exceptions.BadRequest;
import io.intino.konos.alexandria.exceptions.Forbidden;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class PostDeploySystemAction {
    private static Logger logger = Logger.getRootLogger();
    public String user;
    public SystemSchema system;
    public CesarBox box;

    public void execute() throws BadRequest, Forbidden {
        this.check();
        ServerConsul consul = this.searchConsulCandidate();
        if (consul == null) {
            this.notifyResult("Deploying system `" + this.system.packaging().artifact() + "` on " + this.system.runtime().serverName() + ": *Consul not found*");
            throw new Forbidden("Consul not found");
        }
        if (!consul.isAlive()) {
            throw new Forbidden("Consul now is offline");
        }
        this.deploy(consul);
    }

    private void check() throws Forbidden, BadRequest {
        if (!this.isAuthorized()) {
            throw new Forbidden("User '" + this.user + "' has not permissions");
        }
        if (this.box.graph().project(this.system.project()) == null) {
            throw new BadRequest("Project " + this.system.project() + "not found. First register it.");
        }
    }

    private void deploy(ServerConsul consul) {
        new Thread(() -> {
            try {
                new SystemDeployer(this.box, consul, this.system, this.user).deploy();
            }
            catch (IOException | JMSException e) {
                logger.error((Object)e.getMessage());
                this.notifyResult("Error deploying system. " + e.getMessage());
            }
        }).start();
    }

    private boolean isAuthorized() {
        return this.box.graph().responsibleList().stream().anyMatch(r -> r.name$().equals(this.user));
    }

    private void notifyResult(String message) {
        this.box.cesarBot().sendToUser(this.user, message);
    }

    private ServerConsul searchConsulCandidate() {
        List servers = this.box.graph().assetList(u -> u.core$().is(Server.class)).map(unit -> (Server)((Object)unit)).collect(Collectors.toList());
        String specificServer = this.system.runtime().serverName();
        AbstractServer selectedServer = null;
        if (specificServer != null) {
            selectedServer = servers.stream().filter(s -> specificServer.equals(s.name$())).findFirst().orElse(null);
        }
        return selectedServer == null ? null : selectedServer.serverConsul();
    }
}

